<?php

include 'stripe_config.php';

require 'vendor/autoload.php';

include '../con1.php';


// This is your real test secret API key.
\Stripe\Stripe::setApiKey($secret_key);


if(empty($_GET['user_id'])){
    $record=array('success'=>'false', 'msg' =>array('Please send data'));
	echo json_encode($record);
	return false;
}


if(empty($_GET['payment_method'])){
    $record=array('success'=>'false', 'msg' =>array('Please send data'));
	echo json_encode($record);
	return false;
}


if(empty($_GET['amount'])){
    $record=array('success'=>'false', 'msg' =>array('Please send data'));
	echo json_encode($record);
	return false;
}


$user_id = $_GET['user_id'];
$payment_method = $_GET['payment_method'];
$amount = $_GET['amount'];


$descriptor_suffix  =   '0';
$transfer_user_id   =   '0';
$transfer_amount    =   '0';
$check_flag         =   '0';
$appointment_id     =   '0';

$createtime=date('Y-m-d H:i:s');
$updatetime=date('Y-m-d H:i:s');
$payment_status=1;


//------------------------ check customer on db -----------
$response = getStripeCustomerId($user_id);
if($response['status']=='true'){
	$customer_id =   $response['customer_id'];
	
	
	
}else if($response['status']=='false'){
    $record=array('success'=>'false', 'msg' =>$response['msg']);
	echo json_encode($record);
	return false;
}
	
try{
        $amount = $amount*100;

        $response = \Stripe\PaymentIntent::create([
            'amount'             => $amount,//amount must be multiple of 100
            'currency'           => $currency,
            'customer'           => $customer_id,
            'description'        =>$description, //max 22 charcaters
            'payment_method'     =>$payment_method, 
            'off_session' => true,
            'confirm' => true,
        ]);
        
        //print_r($response);die;
        
         //$json_obj_new = $json_obj->setupIntent;
    $status = $response->status;
    if($status == 'succeeded' || $status=='requires_capture'){
            
            $payment_id = $response->id;

            $insert_all=$mysqli->prepare("INSERT INTO stripe_payment_master(user_id, order_id, amount, descriptor_suffix, payment_id, payment_status, paymentIntent, createtime, updatetime, transfer_user_id, transfer_amount) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
            $insert_all->bind_param("iisssisssis", $user_id, $order_id, $amount, $descriptor_suffix,  $payment_id, $payment_status, $paymentIntent, $createtime, $updatetime, $transfer_user_id, $transfer_amount);
            $insert_all->execute();
            
            $message = 'Payment success.';
    
            $output = [
            'success'=>'true','msg'=>array($message,$message), 'payment_id'=>$payment_id
          ];
          echo json_encode($output);
        	return false;
            
            
    }else{
         $message = 'Payment is not done, try again.';
    
            $output = [
            'success'=>'false','msg'=>array($message,$message)
          ];
          echo json_encode($output);
        	return false;
    }
            
} catch (Error $e) {
    
    $message = $e->getMessage();
    
    $output = [
    'success'=>'false','msg'=>array($message,$message)
  ];
  echo json_encode($output);
	return false;
}




function getStripeCustomerId($user_id){
    include '../con1.php';
    
	$seelct_data_all =$mysqli->prepare("SELECT stripe_customer_id, customer_id from stripe_customer_master where delete_flag = 0 AND user_id = ?");
	$seelct_data_all->bind_param("i", $user_id);
	$seelct_data_all->execute();
	$seelct_data_all->store_result();
	$seelct_data = $seelct_data_all->num_rows;  //0 1
	if($seelct_data > 0)
	{
	    $seelct_data_all->bind_result($stripe_customer_id,$customer_id);
	    $seelct_data_all->fetch();
	    
	    $record = array('status'=>'true', 'msg'=>'data found', 'stripe_customer_id'=>$stripe_customer_id,'customer_id'=>$customer_id);
			return $record;
	}else{
	    $record = array('status'=>'false', 'msg'=>'customer not available');
		return $record;
	}
}



?>