<?php

/***************************    Static functions don't any change  *****************************/
// header('Access-Control-Allow-Origin: *');

//---------------------------- generate random number string  ----------
function generateRandomOTP($length = 4)
{
	PHP_VERSION < '4.2.0' && mt_srand((float)microtime() * 1000000);
	$hash = '';
	$chars = '123456789';
	$max = strlen($chars) - 1;
	for ($i = 0; $i < $length; $i++) {
		$hash .= $chars[mt_rand(0, $max)];
	}
	return $hash;
}

//echo $mobile_code = generateRandomOTP(4);


function generateRandomString($length = 10)
{
	$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
	$randomString = '';
	for ($i = 0; $i < $length; $i++) {
		$randomString .= $characters[rand(0, strlen($characters) - 1)];
	}
	return $randomString;
}

//echo $mobile_code = generateRandomString(4);


function timeago($date_time)
{
	$timestamp = strtotime($date_time);

	$strTime = array("sec", "min", "hr", "day", "month", "year");
	$length = array("60", "60", "24", "30", "12", "10");

	$currentTime = time();
	if ($currentTime >= $timestamp) {
		$diff     = time() - $timestamp;
		for ($i = 0; $diff >= $length[$i] && $i < count($length) - 1; $i++) {
			$diff = $diff / $length[$i];
		}

		$diff = round($diff);
		return $diff . " " . $strTime[$i] . " ago ";
	}
}

//------------------------- check user activate or not ---------------------
function checkAccountActivateDeactivate($user_id)
{    
	include 'con1.php';
	$active_status = 0;

	$check_active_all = $mysqli->prepare("SELECT active_flag FROM user_master WHERE user_id=? AND delete_flag =0");
	$check_active_all->bind_param("i", $user_id);
	$check_active_all->execute();
	$check_active_all->store_result();
	$check_active = $check_active_all->num_rows;
	if ($check_active > 0) {
		$check_active_all->bind_result($active_flag_get);
		$check_active_all->fetch();
     	if ($active_flag_get == 1) {
			$active_status = 1;
		}
	}


	return $active_status;
}

// $user_id=1;
// echo $active_status = checkAccountActivateDeactivate($user_id);


//--------------------------------------------------------------------  Notification all functios here -----------------------
function DeviceTokenStore_1_Signal($user_id, $device_type, $player_id)
{
	include('con1.php');

	$inserttime = date("Y-m-d H:i:s");
	//---------------------------------- check device token -----------------------
	$check_player_id_all = $mysqli->prepare("SELECT `player_id` FROM `user_notification` WHERE player_id=?");
	$check_player_id_all->bind_param('s', $player_id);
	$check_player_id_all->execute();
	$check_player_id_all->store_result();
	$check_player_id = $check_player_id_all->num_rows;
	if ($check_player_id > 0) {

		//-------------- delete all record of this player_id -----------------------
		$delete_device_details = $mysqli->prepare("delete from user_notification where player_id=? or user_id=?");
		$delete_device_details->bind_param('si', $player_id, $user_id);
		$delete_device_details->execute();
		$delete_device = $mysqli->affected_rows;
		if ($delete_device <= 0) {

			//--------------- 2nd attemp to deleet -------------------
			$delete_device_details1 = $mysqli->prepare("delete from user_notification where player_id=? or user_id=?");
			$delete_device_details1->bind_param('si', $player_id, $user_id);
			$delete_device_details1->execute();
			$delete_device1 = $mysqli->affected_rows;
			if ($delete_device1 <= 0) {
				$result = "no";
			} else {
				$insert_device_details = $mysqli->prepare("insert into user_notification (user_id, device_type, player_id, inserttime) values(?,?,?,?)");
				$insert_device_details->bind_param('isss', $user_id, $device_type, $player_id, $inserttime);
				$insert_device_details->execute();
				$insert_check = $mysqli->affected_rows;
				if ($insert_check > 0) {
					$result = "yes";
				} else {
					$result  = "no";
				} //insert else closed
			} //insert else closed
		} //insert else closed
		else {
			$insert_device_details = $mysqli->prepare("insert into user_notification (user_id, device_type, player_id, inserttime) values(?,?,?,?)");
			$insert_device_details->bind_param('isss', $user_id, $device_type, $player_id, $inserttime);
			$insert_device_details->execute();
			$insert_check = $mysqli->affected_rows;
			if ($insert_check > 0) {
				$result = "yes";
			} else {
				$result  = "no";
			} //insert else closed
		}
	} else {
		//----------------------- check user_id ------------------------
		$check_player_id_all = $mysqli->prepare("SELECT `user_id` FROM `user_notification` WHERE user_id=?");
		$check_player_id_all->bind_param('i', $user_id);
		$check_player_id_all->execute();
		$check_player_id_all->store_result();
		$check_player_id = $check_player_id_all->num_rows;
		if ($check_player_id > 0) {
			//---------------------- delete all record of this player_id -----------------------

			$delete_device_details = $mysqli->prepare("delete from user_notification where user_id=?");
			$delete_device_details->bind_param('i', $user_id);
			$delete_device_details->execute();
			$delete_device = $mysqli->affected_rows;
			if ($delete_device <= 0) {
				//--------------- 2nd attemp to deleet -------------------
				$delete_device_details1 = $mysqli->prepare("delete from user_notification where user_id=?");
				$delete_device_details1->bind_param('i',  $user_id);
				$delete_device_details1->execute();
				$delete_device1 = $mysqli->affected_rows;
				if ($delete_device1 <= 0) {
					$result = "no";
				} else {
					$insert_device_details = $mysqli->prepare("insert into user_notification (user_id, device_type, player_id, inserttime) values(?,?,?,?)");
					$insert_device_details->bind_param('isss', $user_id, $device_type, $player_id, $inserttime);
					$insert_device_details->execute();
					$insert_check = $mysqli->affected_rows;
					if ($insert_check > 0) {
						$result = "yes";
					} else {
						$result  = "no";
					} //insert else closed
				} //insert else closed
			} //insert else closed
			else {
				$insert_device_details = $mysqli->prepare("insert into user_notification (user_id, device_type, player_id, inserttime) values(?,?,?,?)");
				$insert_device_details->bind_param('isss', $user_id, $device_type, $player_id, $inserttime);
				$insert_device_details->execute();
				$insert_check = $mysqli->affected_rows;
				if ($insert_check > 0) {
					$result = "yes";
				} else {
					$result  = "no";
				} //insert else closed
			}
		} else {
			//------------------------------ insert new record -------------------
			$insert_device_details = $mysqli->prepare("insert into user_notification (user_id, device_type, player_id, inserttime) values(?,?,?,?)");
			$insert_device_details->bind_param('isss', $user_id, $device_type, $player_id, $inserttime);
			$insert_device_details->execute();
			$insert_check = $mysqli->affected_rows;
			if ($insert_check > 0) {
				$result = "yes";
			} else {
				$result  = "no";
			} //insert else closed
		}
	} //esle closed of delete

	return $result;
}
/* user fetch(select) record*/
//echo $result = DeviceTokenStore_1_Signal($user_id, $device_type, $player_id);

function getUserPlayerId($user_id)
{

	include('con1.php');

	$select_all = $mysqli->prepare("SELECT player_id  from user_notification where user_id=?");
	$select_all->bind_param("i", $user_id);
	$select_all->execute();
	$select_all->store_result();
	$select = $select_all->num_rows;
	if ($select > 0) {
		$select_all->bind_result($player_id);
		$select_all->fetch();
		if ($player_id == '123456') {
			$player_id = 'no';
		}
	} else {
		$player_id = 'no';
	}
	return $player_id;
}

/*
$user_id='1';
echo $player_id = getUserPlayerId($user_id);
*/

function getNotificationStatus($user_id)
{
	include('con1.php');

	$select_all = $mysqli->prepare("select user_id  from user_master where user_id=? and notification_status='1'");
	$select_all->bind_param("i", $user_id);
	$select_all->execute();
	$select_all->store_result();
	$select = $select_all->num_rows;
	if ($select > 0) {
		$notification_status = 'yes';
	} else {
		$notification_status = 'no';
	}

	return $notification_status;
}

/*
$user_id='210';
echo $notification_status=getNotificationStatus($user_id)
*/

function InsertNotification($user_id, $other_user_id, $action, $action_id, $action_json, $title,  $message)
{

	include('con1.php');

	$read_status = '0';
	$delete_flag = '0';
	$updatetime = date("Y-m-d H:i:s");
	$createtime = date("Y-m-d H:i:s");


	$insert = $mysqli->prepare("insert into user_notification_message(user_id, other_user_id, action, action_id, action_json, title,title_2,title_3,title_4, message,message_2,message_3,message_4, read_status, delete_flag, createtime, updatetime) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
	$insert->bind_param('iisisssssssssiiss', $user_id, $other_user_id, $action, $action_id, $action_json, $title[0], $title[1], $title[2], $title[3], $message[0], $message[1], $message[2], $message[3], $read_status, $delete_flag, $createtime, $updatetime);
	$insert->execute();
	$insert_check = $mysqli->affected_rows;
	if ($insert_check <= 0) {
		$status = 'no';
	} else {
		$status = 'yes';
	}

	return $status;
}


/*
$user_id='2';
$other_user_id='210';
$action = 'request_sent';
$action_id = '0';
$action_data=array('user_id'=>$user_id,'other_user_id'=>$other_user_id);
$action_json=json_encode($action_data);
$title = 'Sent a request';
$message = 'Amit sent a friend request';
echo $insert_status=InsertNotification($user_id, $other_user_id, $action, $action_id, $action_json, $title, $message);
*/
//----------------------------------  Notification all functions here -----------------------


function getNotificationArrSingle($user_id, $other_user_id, $action, $action_id, $title, $message, $action_data)
{
	// echo $user_id;
	// echo $other_user_id;
	// echo $action;
	// echo $action_id;
	// echo $title;
	// echo $message;
	// echo $action_data;

	$notification_arr = array();
	$action_json = json_encode($action_data);
	$insert_status = InsertNotification($user_id, $other_user_id, $action, $action_id, $action_json, $title, $message);
	if ($insert_status == 'yes') {
		$notification_status = getNotificationStatus($other_user_id);
		if ($notification_status == 'yes') {
			$player_id = getUserPlayerId($other_user_id);
			if ($player_id != 'no') {
				$notification_arr = array('player_id' => $player_id, 'title' => $title, 'message' => $message, 'action_json' => $action_data);
				// print_r($notification_arr);
				// die();
			}
		}
	}

	if (empty($notification_arr)) {
		$notification_arr = 'NA';
	}
	return $notification_arr;
}

/*
$notification_arr = array();
$user_id = $user_id;
$other_user_id = $user_id;

$action = 'login';
$action_id = '0';
$title = 'Login';
$message = 'Welcome to you in APP.';

$action_data=array('user_id'=>$user_id,'other_user_id'=>$other_user_id, 'action_id'=>$action_id, 'action'=>$action);

$notification_arr=getNotificationArrSingle($user_id, $other_user_id,$action,$action_id, $title, $message, $action_data); 
*/

function getNotificationMsgCount($user_id)
{
	include('con1.php');

	$select_all = $mysqli->prepare("SELECT `notification_message_id` FROM `user_notification_message` WHERE user_id = ? and delete_flag =0   and read_status = '0'");
	$select_all->bind_param("i", $user_id);
	$select_all->execute();
	$select_all->store_result();
    $select = $select_all->num_rows;

	//$select=2;

	return $select;
}
function getNotificationMsgCountOtherUser($user_id)
{
	include('con1.php');

	$select_all = $mysqli->prepare("SELECT `notification_message_id` FROM `user_notification_message` WHERE other_user_id = ? and delete_flag =0   and read_status = '0'");
	$select_all->bind_param("i", $user_id);
	$select_all->execute();
	$select_all->store_result();
    $select = $select_all->num_rows;

	//$select=2;

	return $select;
}
// $user_id=2;
// $notification_count=getNotificationMsgCount($user_id);



//----------------------------------------- safe json functions -------------------------
function jsonSendEncode($record)
{
	$data = safe_json_encode($record);
	echo $data;
	exit;
}



function safe_json_encode($value)
{

	if (version_compare(PHP_VERSION, '5.4.0') >= 0) {
		$encoded = json_encode($value, JSON_PRETTY_PRINT);
	} else {
		$encoded = json_encode($value);
	}

	switch (json_last_error()) {
		case JSON_ERROR_NONE:
			return $encoded;
		case JSON_ERROR_DEPTH:
			return 'Maximum stack depth exceeded'; // or trigger_error() or throw new Exception()
		case JSON_ERROR_STATE_MISMATCH:
			return 'Underflow or the modes mismatch'; // or trigger_error() or throw new Exception()
		case JSON_ERROR_CTRL_CHAR:
			return 'Unexpected control character found';
		case JSON_ERROR_SYNTAX:
			return 'Syntax error, malformed JSON'; // or trigger_error() or throw new Exception()
		case JSON_ERROR_UTF8:
			$clean = utf8ize($value);
			return safe_json_encode($clean);
		default:
			return 'Unknown error'; // or trigger_error() or throw new Exception()
	}
}


function utf8ize($mixed)
{
	if (is_array($mixed)) {
		foreach ($mixed as $key => $value) {
			$mixed[$key] = utf8ize($value);
		}
	} else if (is_string($mixed)) {
		return utf8_encode($mixed);
	}
	return $mixed;
}
//----------------------------------------- safe json functions end -------------------------


//---------------------------  upload file function --------------------
function uploadFile1($file, $folder_name, $file_type)
{

	include_once('image_resize.php');

	$file_extension = strtolower(pathinfo(basename($file["name"]), PATHINFO_EXTENSION));

	$str = generateRandomString(15);
	$str2 = rand();
	$image_name = $str . $str2 . '.' . $file_extension;
	$upload_target = $folder_name . "/" . $image_name;

	if (move_uploaded_file($file['tmp_name'], $upload_target)) {

		if ($file_type == 'image') {

			//-------------- IMAGE CROP 200X200 -------------------------------
			$new_width = '200';
			$new_height = '200';
			$uploadDir = $folder_name;
			$moveToDir  = $folder_name . '/200X200';
			//$img_result=createThumbnail($image_name,$new_width,$new_height,$uploadDir,$moveToDir);

			//-------------- IMAGE CROP 400X400 -------------------------------
			$new_width = '400';
			$new_height = '400';
			$uploadDir = $folder_name;
			$moveToDir  = $folder_name . '/400X400';
			//$img_result= createThumbnail($image_name,$new_width,$new_height,$uploadDir,$moveToDir);

			//-------------- IMAGE CROP 700X700 -------------------------------
			$new_width = '700';
			$new_height = '700';
			$uploadDir = $folder_name;
			$moveToDir  = $folder_name . '/700X700';
			//$img_result= createThumbnail($image_name,$new_width,$new_height,$uploadDir,$moveToDir);
		}

		return $image_name;
	} else {
		return 'error';
	}
}

/*
$file=$_FILES['image'];
$folder_name='images';
$file_type='image';
$upload_status=uploadFile($file, $folder_name, $file_type);
*/


// function uploadFileMultiple($file_arr, $folder_name, $file_type) {
// 	require_once('image_resize.php');
//         // print_r($file_arr);
// 	$image_name_arr=array();
// 	for($i=0; $i<count($file_arr["images"]); $i++) 
// 	{
// 		if($file_arr["images"][$i] != ''){
// 			$file_extension = strtolower(pathinfo(basename($file_arr["name"][$i]),PATHINFO_EXTENSION));			
// 			$str= generateRandomString(15);
// 			$str2= rand();
// 			$image_name= $str.$str2.'.'.$file_extension;
// 			$upload_target = $folder_name."/".$image_name; 

// 			if(move_uploaded_file($file_arr['tmp_name'][$i],$upload_target)) {
// 				if($file_type == 'image'){
//             		/************* IMAGE CROP 200X200 *************/
// 					$new_width = '200';
// 					$new_height = '200';
// 					$uploadDir =$folder_name;
// 					$moveToDir  =$folder_name.'/200X200';
// 					$img_result=createThumbnail($image_name,$new_width,$new_height,$uploadDir,$moveToDir);

//     				/************* IMAGE CROP 400X400 *************/
// 					$new_width = '400';
// 					$new_height = '400';
// 					$uploadDir =$folder_name;
// 					$moveToDir  =$folder_name.'/400X400';
// 					$img_result= createThumbnail($image_name,$new_width,$new_height,$uploadDir,$moveToDir);

//     				/************* IMAGE CROP 700X700 *************/
// 					$new_width = '700';
// 					$new_height = '700';
// 					$uploadDir =$folder_name;
// 					$moveToDir  =$folder_name.'/700X700';
// 					$img_result= createThumbnail($image_name,$new_width,$new_height,$uploadDir,$moveToDir);
// 				}
// 				$image_name_arr[] = $image_name;
//                 //return $image_name;
// 			}else{
//         		//return 'error';
//         		//$image_name_arr[]='error';
// 			} 
// 		}
// 	}
//     // for loop closed
//     // print_r($file_arr["name"]);
// 	if(count($file_arr["name"]) == count($image_name_arr)){
// 		return $image_name_arr;
// 	}else{
// 		return 'error'; 
// 	}
// }

/*
$file=$_FILES['image'];
$folder_name='images';
$file_type='image';
$upload_status=uploadFileMultiple($file, $folder_name, $file_type);
*/

// function uploadFileMultiple1($file_arr, $folder_name, $file_type)
// {
// 	require_once('image_resize.php');
// 	// print_r($file_arr);
// 	$image_name_arr = array();
// 	for ($i = 0; $i < count($file_arr["name"]); $i++) {
// 		if ($file_arr["name"][$i] != '') {
// 			$file_extension = strtolower(pathinfo(basename($file_arr["name"][$i]), PATHINFO_EXTENSION));
// 			$str = generateRandomString(15);
// 			$str2 = rand();
// 			$image_name = $str . $str2 . '.' . $file_extension;
// 			$upload_target = $folder_name . "/" . $image_name;

// 			if (move_uploaded_file($file_arr['tmp_name'][$i], $upload_target)) {
// 				if ($file_type == 'image') {
// 					/************* IMAGE CROP 200X200 *************/
// 					$new_width = '200';
// 					$new_height = '200';
// 					$uploadDir = $folder_name;
// 					$moveToDir  = $folder_name . '/200X200';
// 					$img_result = createThumbnail($image_name, $new_width, $new_height, $uploadDir, $moveToDir);

// 					/************* IMAGE CROP 400X400 *************/
// 					$new_width = '400';
// 					$new_height = '400';
// 					$uploadDir = $folder_name;
// 					$moveToDir  = $folder_name . '/400X400';
// 					$img_result = createThumbnail($image_name, $new_width, $new_height, $uploadDir, $moveToDir);

// 					/************* IMAGE CROP 700X700 *************/
// 					$new_width = '700';
// 					$new_height = '700';
// 					$uploadDir = $folder_name;
// 					$moveToDir  = $folder_name . '/700X700';
// 					$img_result = createThumbnail($image_name, $new_width, $new_height, $uploadDir, $moveToDir);
// 				}
// 				$image_name_arr[] = $image_name;
// 				//return $image_name;
// 			} else {
// 				//return 'error';
// 				//$image_name_arr[]='error';
// 			}
// 		}
// 	}
// 	// for loop closed
// 	// print_r($file_arr["name"]);
// 	if (count($file_arr["name"]) == count($image_name_arr)) {
// 		return $image_name_arr;
// 	} else {
// 		return 'error';
// 	}
// }






function updateSocialtoNormal($user_id, $email)
{
	include 'con1.php';

	$check_login_all = $mysqli->prepare("SELECT user_id, user_type, login_type from user_master where delete_flag =0 and email =? and  user_id =?");
	$check_login_all->bind_param("si", $email, $user_id);
	$check_login_all->execute();
	$check_login_all->store_result();
	$check_login = $check_login_all->num_rows;  //0 1
	if ($check_login > 0) {

		$check_login_all->bind_result($user_id, $user_type, $login_type);
		$check_login_all->fetch();

		if ($login_type != 0) {
			$login_type_new = 0;
			$updatetime		=	date("Y-m-d H:i:s");

			$update = $mysqli->prepare("UPDATE user_master SET login_type=?,  updatetime=? WHERE user_id=?");
			$update->bind_param("ssi", $login_type_new, $updatetime, $user_id);
			$update->execute();
			$update_check = $mysqli->affected_rows;
			if ($update_check <= 0) {
				return 'no';
			} else {
				return 'yes';
			}
		} else {
			return 'yes';
		}
	} else {
		return 'yes';
	}
}


function distanceCalculation($point1_lat, $point1_long, $point2_lat, $point2_long, $unit = 'km') {
	// echo '<br>h'.$point1_lat;
	// echo '<br>i'.$point1_long;
	// echo '<br>m'.$point2_lat;
	// echo '<br>a'.$point2_long;
	// Calculate the distance in degrees
	$degrees = 0;
	  if((!empty($point1_lat) && !empty($point2_lat)) && ($point1_lat != "null" && $point2_lat != "null")){
		
			$degrees = rad2deg(acos((sin(deg2rad($point1_lat))*sin(deg2rad($point2_lat))) + (cos(deg2rad($point1_lat))*cos(deg2rad($point2_lat))*cos(deg2rad($point1_long-$point2_long)))));
			if (is_nan($degrees)) {
			  return $distance = 0;
			}
	  }
	// Convert the distance in degrees to the chosen unit (kilometres, miles or nautical miles)
	switch($unit) {
	case 'km':
	$distance = $degrees * 111.13384; // 1 degree = 111.13384 km, based on the average diameter of the Earth (12,735 km)
	break;
	case 'mi':
	$distance = $degrees * 69.05482; // 1 degree = 69.05482 miles, based on the average diameter of the Earth (7,913.1 miles)
	break;
	case 'nmi':
	$distance =  $degrees * 59.97662; // 1 degree = 59.97662 nautic miles, based on the average diameter of the Earth (6,876.3 nautical miles)
	}
	$decimals = 1;
	$distance = number_format($distance, 1, '.', ',');
	return $distance;
  }
  
  function distanceCalculationNearest($point1_lat, $point1_long, $point2_lat, $point2_long, $unit = 'km', $decimals = 2) {
   // Calculate the distance in degrees
   $degrees = rad2deg(acos((sin(deg2rad($point1_lat))*sin(deg2rad($point2_lat))) + (cos(deg2rad($point1_lat))*cos(deg2rad($point2_lat))*cos(deg2rad($point1_long-$point2_long)))));
   if (is_nan($degrees)) {
	 return $distance = 0;
   }
   // Convert the distance in degrees to the chosen unit (kilometres, miles or nautical miles)
   switch($unit) {
   case 'km':
   $distance = $degrees * 111.13384; // 1 degree = 111.13384 km, based on the average diameter of the Earth (12,735 km)
   break;
   case 'mi':
   $distance = $degrees * 69.05482; // 1 degree = 69.05482 miles, based on the average diameter of the Earth (7,913.1 miles)
   break;
   case 'nmi':
   $distance =  $degrees * 59.97662; // 1 degree = 59.97662 nautic miles, based on the average diameter of the Earth (6,876.3 nautical miles)
   }
   return round($distance, $decimals);
  }
  

//----------------- functions send notifcations ---------------
function oneSignalNotificationSendCall($notification_arr)
{
	require_once  '1_signal_final.php';

	//echo 'oneSignalNotificationSendCall'.print_r($notification_arr);
	if ($notification_arr != 'NA') {
		foreach ($notification_arr as $key) {

			$player_id_arr = array();

			if ($key['player_id'] != '') {
				$player_id_arr[] = $key['player_id'];

				$title = $key['title'];
				$message = $key['message'];
				$action_json = $key['action_json'];

				oneSignalNotificationSend($title[0], $message[0], $action_json, $player_id_arr);
			}
		}
	}
}

function oneSignalNotificationSendCallDriver($notification_arr)
{
	require_once  '1_signal_final.php';

	//echo 'oneSignalNotificationSendCall'.print_r($notification_arr);
	if ($notification_arr != 'NA') {
		foreach ($notification_arr as $key) {

			$player_id_arr = array();

			if ($key['player_id'] != '') {
				$player_id_arr[] = $key['player_id'];

				$title = $key['title'];
				$message = $key['message'];
				$action_json = $key['action_json'];

				oneSignalNotificationSendDriver($title[0], $message[0], $action_json, $player_id_arr);
			}
		}
	}
}


//----------------- functions send notifcations end ---------------
//--------------------- image uploading updated code start ---------------------

function formatSizeUnits($bytes)
{
        // if ($bytes >= 1073741824)
        // {
        //     $bytes = number_format($bytes / 1073741824, 2) . ' GB';
        // }
        
        if ($bytes >= 1048576)
        {
        $bytes = number_format($bytes / 1048576, 2); //MB return
        }
        else
        {
        $bytes=0;
        }
        // elseif ($bytes >= 1024)
        // {
        //     $bytes = number_format($bytes / 1024, 2) . ' KB';
        // }
        // elseif ($bytes > 1)
        // {
        //     $bytes = $bytes . ' bytes';
        // }
        // elseif ($bytes == 1)
        // {
        //     $bytes = $bytes . ' byte';
        // }
        // else
        // {
        //     $bytes = '0 bytes';
        // }
        
        return $bytes; //returning in MB
}

function compressImage($source, $destination, $quality) { 
    // Get image info 
    $imgInfo = getimagesize($source); 
    $mime = $imgInfo['mime']; 
     
    // Create a new image from file 
    switch($mime){ 
        case 'image/jpeg': 
            $image = imagecreatefromjpeg($source); 
            break; 
        case 'image/png': 
            $image = imagecreatefrompng($source); 
            break; 
        case 'image/gif': 
            $image = imagecreatefromgif($source); 
            break; 
        default: 
            $image = imagecreatefromjpeg($source); 
    } 
     
    // Save image 
    imagejpeg($image, $destination, $quality); 
     
    // Return compressed image 
    return $destination; 
}
function uploadFile($file, $folder_name, $file_type)
{


    $file_extension = strtolower(pathinfo(basename($file["name"]), PATHINFO_EXTENSION));

    $str = generateRandomString(15);
    $str2 = rand();
    $image_name = $str . $str2 . '.' . $file_extension;
    $upload_target = $folder_name . "/" . $image_name;
    
    if($file_type == 'image'){
        // Allow certain file formats 
        $allowTypes = array('jpg','png','jpeg'); 
        if(in_array($file_extension, $allowTypes)){ 
            // Image temp source and size 
            $imageTemp = $file["tmp_name"]; 
            $imageSize = formatSizeUnits($file["size"]); 
             
             $compressedImage = compressImage($imageTemp, $upload_target,50);
             
            // Compress size and upload image 
            // if($imageSize>1){
            //     $compressedImage = compressImage($imageTemp, $upload_target,50); 
            // }else{
            //     $compressedImage = compressImage($imageTemp, $upload_target,100); 
            // }

            return $image_name;
        } else {
            return 'error';
        }
    }else{
        if(move_uploaded_file($file['tmp_name'],$upload_target)){
            return $image_name;
        }
        else{
            return 'error';
        }
    }
}

/*
$file=$_FILES['image'];
$folder_name='images';
$file_type='image';
$upload_status=uploadFile($file, $folder_name, $file_type);
*/


function uploadFileMultiple($file_arr, $folder_name, $file_type)
{
    //require_once('image_resize.php');
    // print_r($file_arr);
    $image_name_arr = array();
    for ($i = 0; $i < count($file_arr["name"]); $i++) {
        if ($file_arr["name"][$i] != '') {
            
            $file_extension = strtolower(pathinfo(basename($file_arr["name"][$i]), PATHINFO_EXTENSION));
            $str = generateRandomString(15);
            $str2 = rand();
            $image_name = $str . $str2 . '.' . $file_extension;
            $upload_target = $folder_name . "/" . $image_name;
    
             if($file_type == 'image'){
            
                    // Allow certain file formats 
                $allowTypes = array('jpg','png','jpeg'); 
                if(in_array($file_extension, $allowTypes)){ 
                    // Image temp source and size 
                    $imageTemp = $file_arr["tmp_name"][$i]; 
                    $imageSize = formatSizeUnits($file_arr["size"][$i]); 
                     
                     $compressedImage = compressImage($imageTemp, $upload_target,50);
                        $image_name_arr[] = $image_name;
                        //return $image_name;
                    } else {
                        //return 'error';
                        //$image_name_arr[]='error';
                    }
            }else{
                if(move_uploaded_file($file_arr['tmp_name'][$i],$upload_target)){
                    $image_name_arr[] = $image_name;
                }
            }
        }
    }
    // for loop closed
    // print_r($file_arr["name"]);
    if(!empty($image_name_arr)){
        return $image_name_arr;
    } else {
        return 'error';
    }
}

//--------------------- image uploading updated code end ---------------------


