<?php
include('libraryPHP/site_config.php');
include('libraryPHP/session_check_url.php');
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <title><?php echo $appName ?> | <?php echo $pageTitle ?></title>
    <?php echo $appFaviconHtml ?>
    <!-- theme css start -->
    <?php include("commoncss.php"); ?>
    <!-- theme css end -->
</head>

<body>
    <!-- Main Wrapper -->
    <div class="main-wrapper">
        <!-- Header start  -->
        <?php include("header.php"); ?>
        <!-- /Header end -->
        <!-- Sidebar -->
        <?php include("sidebar.php"); ?>
        <!-- /Sidebar -->
        <!-- Page Wrapper -->
        <div class="page-wrapper">
            <div class="content container-fluid">
                <!-- Page Header -->
                <div class="page-header">
                    <div class="row">
                        <div class="col">
                            <h3 class="page-title">Users list</h3>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                <li class="breadcrumb-item active">Users list</li>
                            </ul>
                        </div>
                    </div>
                </div>
                <!-- /Page Header -->
                <!-- start write start -->
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row mb-2">
          <div class="col-sm-12">
            <a  href="add_subadmin.php" class="btn btn-primary float-end" >Add User</a>
          </div>
        </div>
                            <div class="table-responsive">
                                <table id="user_table" class="table table-hover table-bordered" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                    <thead>
                                        <tr>
                                            <th>S.No.</th>
                                            <th>Action</th>
                                             
                                              <th>Image</th>
                                               <th>User Role</th>
                                            <th>User Name</th>
                                          
                                           <th>Email</th>

                                            <th>Mobile No.</th>

                                            <th>Status</th>
                                            <th>Registration On</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div> <!-- end col -->
                <!-- start write end -->
            </div>
        </div>
        <!-- /Page Wrapper -->
        <!-- footer start -->
        <?php include("footer.php"); ?>
        <!-- footer end -->
    </div>
    <!-- /Main Wrapper -->
    <!-- <?php //include("theme_script.php"); 
            ?> -->
    <?php include('commonjs.php') ?>
    <?php include_once('extrajs.php') ?>
    <script>
        var table = '';
        $(document).ready(function() {
            $('#user_table').DataTable();
            getUserTable('first', 'all');
        });
    </script>
    <script>
        function getUserTable(event, type) {
            if (event != 'first') {
                $('.view_class').removeClass('active').prop('disabled', false);
                $(event).addClass('active').prop('disabled', true);
            }
            var link = URLAPI + 'user_controller.php';
            var data = {
                action: 'get_users',
                type: type,
            }
            var messsage = msgLoading.blankMessage[language];
            console.log('messsage', messsage);
            apiRequest.get(link, data, messsage).then(function(obj) {
                console.log('obj', obj);
                if (obj.success === true) {
                    var user_arr = obj.data.user_arr;
                    if (user_arr.length >= 0) {
                        //table.destroy();
                        //$('#table_users').empty();
                        $('#user_table').DataTable({
                            data: user_arr,
                            "destroy": true,
                            "paging": true,
                            "lengthChange": true,
                            "searching": true,
                            "ordering": true,
                            "info": true,
                            "autoWidth": false,
                            "responsive": true,
                            "aaSorting": [
                                [0, "asc"]
                            ],
                            "bJQueryUI": "true",
                            "sPaginationType": "full_numbers",
                            "iDisplayLength": 15,
                            "aLengthMenu": [
                                [ 15,20, 25, 50, 100, 200, -1],
                                [15, 20, 25, 50, 100, 200, "All"]
                            ],
                            "columns": [
                                //  { "data": "select" },
                                {
                                    "data": "srno"
                                },
                                {
                                    "data": "action"
                                },
                                {
                                    "data": "image"
                                },
                                {
                                    "data": "role_text"
                                },
                                {
                                    "data": "username"
                                },
                                 
                                { "data": "email" },
                                
                                { "data": "mobile" },
                                {
                                    "data": "active_flag"
                                },
                                {
                                    "data": "createtime"
                                },
                            ],
                            "rowId": "user_id",
                        });
                    } else {
                        dataTable.fnClearTable();
                        dataTable.fnDraw();
                        dataTable.fnDestroy();
                    }
                } else {
                    //------------ Operation Message --------------------
                    var title = msgTitleOperation.blankMessage[language];
                    var messsage = obj.msg[language];
                    msgSuccessErrorHtml.error(title, messsage, '#msgSuccessErrorHtml');
                    //------------ Operation Message End--------------------
                    return false;
                }
            }, function(err) {
                console.log('err', err);
                //------------ Operation Message --------------------
                var title = msgTitleOperation.errorOnServer[language];
                var messsage = msgOperations.errorOnServer[language];
                msgSuccessErrorHtml.warning(title, messsage, '#msgSuccessErrorHtml');
                //------------ Operation Message End--------------------
                return false;
            });
        }

        function btnUserActivateDeactivateConfirm(event) {
            var user_id = $(event).attr('data-id');
            var status = $(event).attr('data-user-status');
            console.log('status', status);
            if (status == '1') {
                var text = msgConfim.userActivated[language];
            } else {
                var text = msgConfim.userDeactivated[language];
            }
            swal({
                    title: '',
                    text: text,
                    icon: "warning", //error, success, info
                    buttons: ["Cancel", "Ok"],
                })
                .then((willDelete) => {
                    if (willDelete) {
                        btnUserActivateDeactivateContinue(event, user_id, status);
                    } else {
                        //swal("Your imaginary file is safe!");
                    }
                });
        }

        function btnUserActivateDeactivateContinue(event, user_id, active_flag) {
            //   alert(active_flag);
            var link = URLAPI + 'user_controller.php';
            var data = {
                action: 'activate_deactivate_user',
                user_id: user_id,
                active_flag: active_flag,
            }
            var messsage = msgLoading.blankMessage[language];
            console.log('messsage', messsage);
            apiRequest.get(link, data, messsage).then(function(obj) {
                console.log('obj', obj);
                if (obj.success === true) {
                    //------------ Operation Message --------------------
                    if (active_flag == '0') {
                        var title = msgTitleOperation.blankMessage[language];
                    } else {
                        var title = msgTitleOperation.blankMessage[language];
                    }
                    var messsage = obj.msg[language];
                    msgSuccessErrorHtml.success(title, messsage, msgSuccessErrorHtmlSelector);
                    //------------ Operation Message End--------------------
                    swal({
                        title: title,
                        text: messsage,
                        icon: "success", //error, success, info
                        button: "Ok",
                    }).then((value) => {
                        window.location.href = "#";
                        getUserTable('first', 'all');
                    });
                    // //-------------- DataTable Row Action -----------------
                    $('#user_table').dataTable().fnUpdate(obj.data.active_flag_html, $('tr#' + user_id), 7, false);
                    $('#user_table').dataTable().fnUpdate(obj.data.action_html, $('tr#' + user_id), 1, false);
                    //-------------- DataTable Row Action end -----------------
                    return false;
                } else {
                    //------------ Operation Message --------------------
                    var title = msgTitleOperation.blankMessage[language];
                    var messsage = obj.msg[language];
                    msgSuccessErrorHtml.error(title, messsage, msgSuccessErrorHtmlSelector);
                    swal({
                        title: title,
                        text: messsage,
                        icon: "error", //error, success, info
                        button: "Ok",
                    }).then((value) => {
                        window.location.href = "#";
                    });
                    //------------ Operation Message End--------------------
                    return false;
                }
            }, function(err) {
                console.log('err', err);
                //alert('Server not responde');
                //------------ Operation Message --------------------
                var title = msgTitleOperation.errorOnServer[language];
                var messsage = msgOperations.errorOnServer[language];
                msgSuccessErrorHtml.error(title, messsage, msgSuccessErrorHtmlSelector);
                swal({
                    title: title,
                    text: messsage,
                    icon: "error", //error, success, info
                    button: "Ok",
                }).then((value) => {
                    window.location.href = "#";
                });
                //------------ Operation Message End--------------------
                return false;
            });
        }

         function btnUserDeleteConfirm(event){
            var user_id = $(event).attr('data-id');

            Swal({
title: "Are you sure want to delete user account!",
text: "Enter Delete Reason",
input: 'textarea',
showCancelButton: true ,
confirmButtonColor: 'green',
inputValidator: (result) => {
    return !result && 'Please enter delete reason'
  },
 
}).then((result) => {
if (result.value) {
   
   
    btnUserDeleteContinue(event,user_id,result.value);

}
// else{
//     alert('Please enter delete reason');
//     return false;
// }
}
);
           
        }
     function btnUserDeleteContinue(event, user_id,reason){
    
        var link = URLAPI+'user_controller.php';
        var data = {
            action:'delete_user',
            user_id:user_id,
            reason:reason
        }
    
        var messsage = msgLoading.blankMessage[language];
        console.log('messsage',messsage);
        
        apiRequest.get(link, data, messsage).then(function(obj){
            console.log('obj',obj);
            if(obj.success === true) { 
            var title = '';
            var messsage = obj.msg[language];
           
           swal({
                        title: title,
                        text: messsage,
                        icon: "success", //error, success, info
                        button: "Ok",
                    }).then((value) => {
                        window.location.href = "#";
                        getUserTable('first', 'all');
                    });
            getUserTable('first', 'all');
            //-------------- DataTable Row Action end ---------
            return false;
                
    
            } else {
                //------------ Operation Message --------------------
                var title = msgTitleOperation.userDeleted[language];
                var messsage = obj.msg[language];
                msgSuccessErrorHtml.error(title, messsage, msgSuccessErrorHtmlSelector);
                //------------ Operation Message End--------------------
                return false;
            }
        },function(err){
            console.log('err',err); 
            //alert('Server not responde');
    
            //------------ Operation Message --------------------
            var title = msgTitleOperation.errorOnServer[language];
            var messsage = msgOperations.errorOnServer[language];
            msgSuccessErrorHtml.warning(title, messsage, msgSuccessErrorHtmlSelector);
            //------------ Operation Message End--------------------
            return false;      
        });
    }
    </script>
</body>

</html>