<?php
include('libraryPHP/site_config.php');
include('libraryPHP/session_check_url.php');
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <title><?php echo $appName ?> | <?php echo $pageTitle ?></title>
    <?php echo $appFaviconHtml ?>
    <!-- theme css start -->
    <?php include("commoncss.php"); ?>
    <!-- theme css end -->

</head>

<body>
    <!-- Main Wrapper -->
    <div class="main-wrapper">
        <!-- Header start  -->
        <?php include("header.php"); ?>
        <!-- /Header end -->
        <!-- Sidebar -->
        <?php include("sidebar.php"); ?>
        <!-- /Sidebar -->
        <!-- Page Wrapper -->
        <div class="page-wrapper">
            <div class="content container-fluid">
                <!-- Page Header -->
                <div class="page-header">
                    <div class="row">
                        <div class="col">
                            <h3 class="page-title">Manage Maintainance</h3>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                <li class="breadcrumb-item active">Manage Maintainance</li>
                            </ul>
                        </div>
                    </div>
                </div>
                <!-- /Page Header -->
                <!-- start write start -->
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row mb-2">
                              <div class="col-sm-12">
                                <a  href="add_maintainance.php" class="btn btn-primary float-end" >Add Maintainance</a>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table id="user_table" class="table table-hover table-bordered" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                <thead>
                                    <tr>
                                        <th>S.No.</th>
                                        <th>Action</th>
                                        
                                        
                                        <th>Equipment Type</th>
                                        <th>Equipment Name</th>

                                          <th>Title</th>
                                        
                                        <th>Maintainance Date</th>

                                        <th>Next Maintainance Date</th>

                                        
                                        <th>Create Date & Time</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div> <!-- end col -->
            <!-- start write end -->
        </div>
    </div>
    <!-- /Page Wrapper -->
    <!-- footer start -->
    <?php include("footer.php"); ?>
    <!-- footer end -->
</div>
<!-- /Main Wrapper -->
    <!-- <?php //include("theme_script.php"); 
?> -->
<?php include('commonjs.php') ?>
<?php include_once('extrajs.php') ?>


<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.0.1/css/buttons.dataTables.min.css">
<script src="https://cdn.datatables.net/buttons/1.5.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.colVis.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/rowgroup/1.0.4/js/dataTables.rowGroup.min.js"></script>
<script src="https://cdn.datatables.net/select/1.2.7/js/dataTables.select.min.js"></script>
<script src="https://cdn.datatables.net/fixedheader/3.1.5/js/dataTables.fixedHeader.min.js"> </script>
<script>
    var table = '';
    $(document).ready(function() {
        $('#user_table').DataTable();
        getUserTable('first', 'all');
    });
</script>
<script>
    function getUserTable(event, type) {
        if (event != 'first') {
            $('.view_class').removeClass('active').prop('disabled', false);
            $(event).addClass('active').prop('disabled', true);
        }
        var link = URLAPI + 'manage_all_controller.php';
        var data = {
            action: 'get_maintainance',
            type: type,
        }
        var messsage = msgLoading.blankMessage[language];
        console.log('messsage', messsage);
        apiRequest.get(link, data, messsage).then(function(obj) {
            console.log('obj', obj);
            if (obj.success === true) {
                var user_arr = obj.data.user_arr;
                if (user_arr.length >= 0) {
                        //table.destroy();
                        //$('#table_users').empty();
                        $('#user_table').DataTable({
                            data: user_arr,
                            "destroy": true,
                            "paging": true,
                            "lengthChange": true,
                            "searching": true,
                            "ordering": true,
                            "info": true,
                            "autoWidth": false,
                            "responsive": true,
                            "aaSorting": [
                            [0, "asc"]
                            ],
                            "bJQueryUI": "true",
                            "sPaginationType": "full_numbers",
                            "iDisplayLength": 5,
                            "aLengthMenu": [
                            [5, 10, 25, 50, 100, 200, -1],
                            [5, 10, 25, 50, 100, 200, "All"]
                            ],
                            
                            "columns": [
                                //  { "data": "select" },
                                {
                                    "data": "srno"
                                },
                                {
                                    "data": "action"
                                },
                                {
                                    "data": "equipmentTypeName"
                                },
                                {
                                    "data": "equipmentName"
                                },
                                 {
                                    "data": "maintainance_title"
                                },
                                {
                                    "data": "maintainance_date"
                                },
                                {
                                    "data": "next_maintainance_date"
                                },
                                
                                
                                {
                                    "data": "createtime"
                                },
                                ],
                                dom: 'Blfrtip',
                                    buttons: [{
                                        extend: 'excel',
                                        text: 'Export to Excel',
                                        title: 'Leads IMS App - Maintainance Report List',
                                        footer: true,
                                        exportOptions: {
                                            columns: [0,2,3,4,5,6,7]
                                        }
                                    }]
                                
                            });
                    } else {
                        dataTable.fnClearTable();
                        dataTable.fnDraw();
                        dataTable.fnDestroy();
                    }
                } else {
                    //------------ Operation Message --------------------
                    var title = msgTitleOperation.blankMessage[language];
                    var messsage = obj.msg[language];
                    msgSuccessErrorHtml.error(title, messsage, '#msgSuccessErrorHtml');
                    //------------ Operation Message End--------------------
                    return false;
                }
            }, function(err) {
                console.log('err', err);
                //------------ Operation Message --------------------
                var title = msgTitleOperation.errorOnServer[language];
                var messsage = msgOperations.errorOnServer[language];
                msgSuccessErrorHtml.warning(title, messsage, '#msgSuccessErrorHtml');
                //------------ Operation Message End--------------------
                return false;
            });
    }

    

    function btnUserDeleteConfirm(event){
        var main_id = $(event).attr('data-id');
        swal({
          title: '',
          text: 'Are you sure want to delete maintainance?',
              icon: "warning", //error, success, info
              buttons:  ["Cancel", "Ok"],
              //dangerMode: true,
          })
        .then((willDelete) => {
          if (willDelete) {
            btnUserDeleteContinue(event, main_id);
        } else {
                //swal("Your imaginary file is safe!");
            }
        });
    }
    function btnUserDeleteContinue(event, main_id){
        
        var link = URLAPI+'manage_all_controller.php';
        var data = {
            action:'delete_maintainance',
            main_id:main_id,
        }
        
        var messsage = msgLoading.blankMessage[language];
        console.log('messsage',messsage);
        
        apiRequest.get(link, data, messsage).then(function(obj){
            console.log('obj',obj);
            if(obj.success === true) { 
                var title = '';
                var messsage = obj.msg[language];
                var messsage = obj.msg[language];
                swal_alert(title,messsage,"#","success");
                getUserTable('first', 'all');
            //-------------- DataTable Row Action end ---------
            return false;
            
            
        } else {
                //------------ Operation Message --------------------
                var title = msgTitleOperation.userDeleted[language];
                var messsage = obj.msg[language];
                msgSuccessErrorHtml.error(title, messsage, msgSuccessErrorHtmlSelector);
                //------------ Operation Message End--------------------
                return false;
            }
        },function(err){
            console.log('err',err); 
            //alert('Server not responde');
            
            //------------ Operation Message --------------------
            var title = msgTitleOperation.errorOnServer[language];
            var messsage = msgOperations.errorOnServer[language];
            msgSuccessErrorHtml.warning(title, messsage, msgSuccessErrorHtmlSelector);
            //------------ Operation Message End--------------------
            return false;      
        });
    }
    
</script>
</body>

</html>