		<?php
		// FILE FOR AUTHENTICATION
		/*
		All possible functions
		- login
		- logout
		- forgotpassword
		- signup
		- emailverify
		*/
		if ($_SERVER['REQUEST_METHOD'] == 'GET') {
			$action = $_GET['action'];
			include('config.php');
			include('common_functions.php');
			include('common_functions_app.php');
			switch ($action) {
				case 'email_check_edit': {
					emailCheckEdit($_GET);
					break;
				}

				case 'email_check_edit1': {
					emailCheckEdit1($_GET);
					break;
				}
				case 'email_check_add': {
					emailCheckadd($_GET);
					break;
				}

				case 'equipment_check_add': {
					equipmentCheckadd($_GET);
					break;
				}

				case 'inspectiontitle_check_add': {
					inspectiontitleCheckadd($_GET);
					break;
				}

				case 'inspectiontitle_check_edit': {
					inspectiontitleCheckEdit($_GET);
					break;
				}

					case 'maintainance_check_add': {
					maintainanceCheckadd($_GET);
					break;
				}

				case 'maintainance_check_edit': {
					maintainanceCheckEdit($_GET);
					break;
				}

				case 'add_inspection_type_check': {
					inspectionTypeCheckadd($_GET);
					break;
				}


				case 'edit_inspection_type_check': {
					inspectionTypeCheckedit($_GET);
					break;
				}


				


				

				case 'equipment_check_edit': {
					equipmentCheckEdit($_GET);
					break;
				}



				

				

				case 'verify_user': {
					updateUserVerifiedStatus($_GET);
					break;
				}

				case 'suggest_user': {
					updateUserSuggestedStatus($_GET);
					break;
				}

                case 'mobile_check_add': {
					mobileCheckadd($_GET);
					break;
				}
				case 'get_users': {
					getUsers($_GET);
					break;
				} 

				case 'get_deleted_users': {
					getDeletedUsers($_GET);
					break;
				}
				
				

				
				

				
				

				
				
				
				
				
				
				
				

				case 'get_subadmin': {
					getSubadmin($_GET);
					break;
				}


				case 'delete_user1': {
				deleteUser1($_GET);
				break;
			}

				
				

				
				

				


				case 'delete_user': {
					deleteUser($_GET);
					break;
				}
				case 'activate_deactivate_user': {
					updateUserActiveDeactiveStatus($_GET);
					break;
				} 
				

				

				

				



				case 'mark_as_approve' : { 
					MarkAsApprove($_GET);
					break;
				}


				case 'edit_admin_detail': {
					getEditAdminDetail($_GET);
					break;
				}
				case 'get_contact_us': {
					getContactUs($_GET);
					break;
				}

				default:
				$record = array('success' => false, 'msg' => 'Invalid Action', 'data' => array());
				jsonSendEncode($record);
			}
		}
		if ($_SERVER['REQUEST_METHOD'] == 'POST') {
			$action = $_POST['action'];
			include('config.php');
			include('common_functions.php');
			include('common_functions_app.php');
			switch ($action) {
				case 'add_user': {
					AddUser($_POST);
					break;
				}

				case 'edit_user': {
					editUser($_POST);
					break;
				}
				case 'editadminprofile': {
					editAdminProfile($_POST);
					break;
				}
				case 'edit_admin_password': {
					editAdminPassword($_POST);
					break;
				}
				case 'edit_user_password': {
					editUserPassword($_POST);
					break;
				}
				case 'delete_activate_deactivate_user_selected': {
					updateUserActiveDeactiveDeleteStatus($_POST);
					break;
				}
				default:
				include_once('language_message.php');
				$record = array('success' => false, 'msg' => $msgValidAction, 'data' => array());
				jsonSendEncode($record);
			}
		}
		function AddUser($data)
		{
			global $mysqli;
			include_once('language_message.php');
			if (empty($data['f_name'])) {
				$record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
				jsonSendEncode($record);
			} else {
				$f_name = $data['f_name'];
				$l_name = $data['l_name'];
				$name = $f_name . ' ' . $l_name;
				$mobile = $data['mobile'];
				$profile_complete = 1;
				$user_type = 1;
				$active_flag = 0;
				$delete_flag = 0;
				$createtime = date('Y-m-d H:i:s');
				$updatetime = date('Y-m-d H:i:s');
				$insert_user_all = $mysqli->prepare("INSERT INTO user_master (f_name,l_name,name,mobile,user_type,profile_complete,delete_flag,active_flag,createtime,updatetime)values(?,?,?,?,?,?,?,?,?,?)");
				$insert_user_all->bind_param('ssssiiiiss', $f_name, $l_name, $name, $mobile, $user_type, $profile_complete, $delete_flag, $active_flag, $createtime, $updatetime);
				$insert_user_all->execute();
				$insert_user = $mysqli->affected_rows;
				if ($insert_user <= 0) {
					$record = array('success' => false, 'msg' => $msgUserAddedError, 'data' => array());
					jsonSendEncode($record);
				}
				$record = array('success' => true, 'msg' => $msgUserAddedSuccess, 'data' => array());
				jsonSendEncode($record);
			}
		}
		function editUser($data)
		{
			global $mysqli;
			include_once('language_message.php');
			// print_r($data);
			if (empty($data['user_id']) && empty($data['f_name']) && empty($data['l_name']) && empty($data['mobile'])) {
				$record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
				jsonSendEncode($record);
			} else {
				$user_id = decode($data['user_id']);
				$f_name = $data['f_name'];
				$l_name = $data['l_name'];
				$name = $f_name . ' ' . $l_name;
				$mobile = $data['mobile'];
				$updatetime = date('Y-m-d H:i:s');
				$update_user = $mysqli->prepare("UPDATE user_master SET f_name=?,l_name=?,name=?,mobile=?,updatetime=? where user_id=?");
				$update_user->bind_param('sssssi', $f_name, $l_name, $name, $mobile, $updatetime, $user_id);
				$update_user->execute();
				$update = $update_user->affected_rows;
				if ($update <= 0) {
					$record = array('success' => false, 'msg' => $msgUserNotUpdate, 'data' => array());
					jsonSendEncode($record);
				} else {
					$record = array('success' => true, 'msg' => $msgUserSuccessUpdate, 'data' => array());
					jsonSendEncode($record);
				}
			}
		}
		function emailCheckEdit($data)
		{
			global $mysqli;
			include_once('language_message.php');
			//print_r($data);
			if (empty($data['email'])) {
				echo 'false';
			} else {
				$email 		= trim($data['email']);
				$user_id 		= decode($data['id']);
				//-------------------------- check user email --------------------------
				$check_email_mobile = $mysqli->prepare("SELECT user_id from user_master where delete_flag='0' and email=? and user_id!=?");
				$check_email_mobile->bind_param("si", $email, $user_id);
				$check_email_mobile->execute();
				$check_email_mobile->store_result();
				$check_email_mobile_count = $check_email_mobile->num_rows;
				if ($check_email_mobile_count > 0) {
					echo 'false';
				} else {
					echo "true";
				}
			}
		}


			function emailCheckEdit1($data)
		{
			global $mysqli;
			include_once('language_message.php');
			//print_r($data);
			if (empty($data['email'])) {
				echo 'false';
			} else {
				$email 		= trim($data['email']);
				$user_id 		= $data['id'];
				//-------------------------- check user email --------------------------
				$check_email_mobile = $mysqli->prepare("SELECT user_id from user_master where delete_flag='0' and email=? and user_id!=?");
				$check_email_mobile->bind_param("si", $email, $user_id);
				$check_email_mobile->execute();
				$check_email_mobile->store_result();
				$check_email_mobile_count = $check_email_mobile->num_rows;
				if ($check_email_mobile_count > 0) {
					echo 'false';
				} else {
					echo "true";
				}
			}
		}
		//-------------------email check add------------------------------------------//
		function emailCheckadd($data)
		{
			global $mysqli;
			include_once('language_message.php');
			//print_r($data);
			if (empty($data['email'])) {
				echo 'false';
			} else {
				$email 		= trim($data['email']);
				//$user_id 		= decode($data['id']);
				//-------------------------- check user email --------------------------
				$check_email_mobile = $mysqli->prepare("SELECT user_id from user_master where delete_flag='0' and email=? ");
				$check_email_mobile->bind_param("s", $email);
				$check_email_mobile->execute();
				$check_email_mobile->store_result();
				$check_email_mobile_count = $check_email_mobile->num_rows;
				if ($check_email_mobile_count > 0) {
					echo 'false';
				} else {
					echo "true";
				}
			}
		}
		//---------------------end of email  check add----------------------------------//
		function getContactUs($data)
		{
			global $mysqli;
			include_once('language_message.php');
			//print_r($data);
			if (empty($data['type'])) {
				$record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
				jsonSendEncode($record);
			} else {
				$type 		= $data['type'];
				$srno = 1;
				//for($i=0; $i<50; $i++){
				if ($type == 'all') {
					$check_data = $mysqli->prepare("SELECT contact_id,user_id,name,phone_number,message,createtime FROM `contact_us_master` where delete_flag='0' order by contact_id desc ");
				}
				//$check_data->bind_param("s",$email);
				$check_data->execute();
				$check_data->store_result();
				$check_data_count = $check_data->num_rows;
				if ($check_data_count > 0) {
					$check_data->bind_result($contact_id, $user_id, $name, $phone_number, $message, $createtime);
					while ($check_data->fetch()) {
						$createtime = date('Y-m-d h:i A', strtotime($createtime));
						$user_name = getUserName($user_id);

						$action_html = '<a href="add_reply.php?id=' . encode($contact_id) . '" class="dropdown-item"><button type="button" class="btn btn-primary">
						Reply</button></a>';
						$contact_arr[] = array('srno' => $srno, 'contact_id' => $contact_id, 'user_id' => $user_name, 'message' => $message, 'mobile' => $phone_number, 'createtime' => $createtime, 'action' => $action_html);
						$srno++;
					}
				}
				//}
				if (empty($contact_arr)) {
					$contact_arr = array();
				}
				$record = array('success' => true, 'msg' => $msgDataFound, 'data' => array('contact_arr' => $contact_arr));
				jsonSendEncode($record);
			}
		}

		function getEditAdminDetail($data)
		{
			global $mysqli;
			include_once('language_message.php');
			if (empty($data['id'])) {
				$record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
				jsonSendEncode($record);
			} else {
				$user_id = decode($data['id']);
				//$user_arr = array();
				$check_data = $mysqli->prepare("SELECT user_id, name, email, mobile, gender,image from user_master where delete_flag= 0 and user_type = 0 and user_id=?");
				$check_data->bind_param('i', $user_id);
				$check_data->execute();
				$check_data->store_result();
				$check_data_count = $check_data->num_rows;
				if ($check_data_count <= 0) {
					$record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
					jsonSendEncode($record);
				} else {
					$check_data->bind_result($user_id, $name, $email, $mobile, $gender, $image);
					$check_data->fetch();

					$user_arr = array('user_id' => $user_id, 'name' => $name, 'email' => $email, 'mobile' => $mobile, 'gender' => $gender, 'image' => $image);
					$record = array('success' => true, 'msg' => $msgDataFound, 'data' => $user_arr);
					jsonSendEncode($record);
				}
			}
		}
		function updateUserActiveDeactiveDeleteStatus($data)
		{
			global $mysqli;
			include_once('language_message.php');
			include('mailFunctions.php');
			include('site_config.php');
			//print_r($data);
			if (empty($data['user_id_arr']) && empty($data['status'])) {
				$record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
				jsonSendEncode($record);
			} else {
				$user_id_arr 		= $data['user_id_arr'];
				$status 		= $data['status'];
				//echo $user_id_arr_str = implode(',', $user_id_arr);
				if ($status == 'delete') {
					$updatetime = date('Y-m-d H:i:s');
					$update_all = $mysqli->prepare("UPDATE user_master set delete_flag='1', updatetime=? WHERE user_id  IN ($user_id_arr)");
					$update_all->bind_param("s", $updatetime);
					$update_all->execute();
					//echo 'error='.mysqli_error($mysqli);
					$update = $mysqli->affected_rows;
					if ($update <= 0) {
						$record = array('success' => false, 'msg' => $msgUserDeleteError, 'data' => array());
						jsonSendEncode($record);
					}
					$record = array('success' => true, 'msg' => $msgUserDeleteSuccess, 'data' => array());
					jsonSendEncode($record);
				} else if ($status == 'activate') {
					$updatetime = date('Y-m-d H:i:s');
					$update_all = $mysqli->prepare("UPDATE user_master set active_flag='1', updatetime=? WHERE user_id  IN ($user_id_arr)");
					$update_all->bind_param("s", $updatetime);
					$update_all->execute();
					//echo 'error='.mysqli_error($mysqli);
					$update = $mysqli->affected_rows;
					if ($update <= 0) {
						$record = array('success' => false, 'msg' => $msgUserActivatedError, 'data' => array());
						jsonSendEncode($record);
					}
					$check_user = $mysqli->prepare("SELECT user_id,email,name,active_flag from user_master where delete_flag='0' and user_id  IN ($user_id_arr)");
					//$check_user->bind_param("i",$user_id);
					$check_user->execute();
					$check_user->store_result();
					$check_user_count = $check_user->num_rows;
					if ($check_user_count > 0) {
						$check_user->bind_result($user_id, $email, $name, $active_flag);
						while ($check_user->fetch()) {
							if ($active_flag == 1) {
								$active_flag_html = 'your account has been Activated by admin.';
							} else if ($active_flag == 0) {
								$active_flag_html = 'your account has been Deactivated by admin for some resons.';
							}
							$postData['fromName']       =   'Picolay App';
							$postData['app_name']       =   $appName;
							$postData['app_logo']       =   $appLogo;
							$postData['app_bg']         =   'app_bg';
							$postData['name']           =   $name;
							$postData['email']          =   $email;
							$postData['mailContent']    = $active_flag_html;
							$postData['approve_flag']   =   $active_flag;
							$subject =  "User Details";
							$postData['mail_msg']	    =   $subject;
							//$postData['Image']=$img_url_user_main.$image;
							$mailBody =	mailBodyApprove($postData);
							$mailResponse =	mailSend($postData['email'], $postData['fromName'], $subject, $mailBody);
						}
					}
					$record = array('success' => true, 'msg' => $msgUserActivatedSuccess, 'data' => array());
					jsonSendEncode($record);
				} else if ($status == 'deactivate') {
					$updatetime = date('Y-m-d H:i:s');
					$update_all = $mysqli->prepare("UPDATE user_master set active_flag='0', updatetime=? WHERE user_id  IN ($user_id_arr)");
					$update_all->bind_param("s", $updatetime);
					$update_all->execute();
					//echo 'error='.mysqli_error($mysqli);
					$update = $mysqli->affected_rows;
					if ($update <= 0) {
						$record = array('success' => false, 'msg' => $msgUserDeactivatedError, 'data' => array());
						jsonSendEncode($record);
					}
					$check_user = $mysqli->prepare("SELECT user_id,email,name,active_flag from user_master where delete_flag='0' and user_id  IN ($user_id_arr)");
					//$check_user->bind_param("i",$user_id);
					$check_user->execute();
					$check_user->store_result();
					$check_user_count = $check_user->num_rows;
					if ($check_user_count > 0) {
						$check_user->bind_result($user_id, $email, $name, $active_flag);
						while ($check_user->fetch()) {
							if ($active_flag == 1) {
								$active_flag_html = 'your account has been Activated by admin.';
							} else if ($active_flag == 0) {
								$active_flag_html = 'your account has been Deactivated by admin for some resons.';
							}
							$postData['fromName']       =   'Picolay App';
							$postData['app_name']       =   $appName;
							$postData['app_logo']       =   $appLogo;
							$postData['app_bg']         =   'app_bg';
							$postData['name']           =   $name;
							$postData['email']          =   $email;
							$postData['mailContent']    = $active_flag_html;
							$postData['approve_flag']   =   $active_flag;
							$subject =  "User Details";
							$postData['mail_msg']	    =   $subject;
							//$postData['Image']=$img_url_user_main.$image;
							$mailBody =	mailBodyApprove($postData);
							$mailResponse =	mailSend($postData['email'], $postData['fromName'], $subject, $mailBody);
						}
					}
					$record = array('success' => true, 'msg' => $msgUserDeactivatedSuccess, 'data' => array());
					jsonSendEncode($record);
				}
			}
		}
		function deleteUser($data)
		{
			global $mysqli;
			include_once('language_message.php');
			include('mailFunctions.php');
			include('site_config.php');
			//print_r($data);exit;
			if (empty($data['user_id'])) {
				$record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
				jsonSendEncode($record);
			} else {
				$user_id 		= $data['user_id'];
				$delete_reason =$data['reason'];
				//$user_id = decode($user_id);
				$check_user_id = $mysqli->prepare("SELECT user_id,name,email from user_master where delete_flag='0' and user_id=?");
				$check_user_id->bind_param("i", $user_id);
				$check_user_id->execute();
				$check_user_id->store_result();
				$check_user_id_count = $check_user_id->num_rows;
				if ($check_user_id_count <= 0) {
					$record = array('success' => false, 'msg' => $msgUserNotExist, 'data' => array());
					jsonSendEncode($record);
				}
				$check_user_id->bind_result($user_id_get,$name_get,$email_get);
				$check_user_id->fetch();

				$updatetime = date('Y-m-d H:i:s');
				$update_all = $mysqli->prepare("UPDATE user_master set delete_flag='1', updatetime=?,delete_reason=? WHERE user_id=?");
				$update_all->bind_param("ssi", $updatetime,$delete_reason, $user_id);
				$update_all->execute();
				//echo 'error='.mysqli_error($mysqli);
				$update = $mysqli->affected_rows;
				if ($update <= 0) {
					$record = array('success' => false, 'msg' => $msgUserDeleteError, 'data' => array());
					jsonSendEncode($record);
				}

				
				$active_flag_html = 'your account has been Deleted by admin for some resons.';
				
				$postData['fromName']       =   $appName;
				$postData['app_name']       =   $appName;
				$postData['app_logo']       =   $appLogo;
				$postData['app_bg']         =   'app_bg';
				$postData['name']           =   $name_get;
				$postData['email']          =   $email_get;
				$postData['mailContent']    = $active_flag_html;
				
				$subject =  "Account Info";
				$postData['mail_msg']	    =   $subject;
					//$postData['Image']=$img_url_user_main.$image;
				$mailBody =	mailBodyApprove($postData);
				$mailResponse =	mailSend($postData['email'], $postData['fromName'], $subject, $mailBody);	
				$record = array('success' => true, 'msg' => $msgUserDeleteSuccess, 'data' => array());
				jsonSendEncode($record);
			}
		}




		//mark as Approve start


		function MarkAsApprove($data) {

		  // echo"<pre>";print_r($data);exit;
			error_reporting(0);
			
			global $mysqli;
			include_once('language_message.php');
			include('mailFunctions.php');
			include('site_config.php');
			include_once('language_message.php');
			if(empty($data['user_id'])) {
				$record =   array('success'=>false, 'msg'=>$msgEmptyAll,'data'=>array()); 
				jsonSendEncode($record); 
			} 
			else {
				$user_id    =decode($data['user_id']);
		             // echo "SELECT user_id from user_master where approve_flag='0' and user_id=$user_id";die;

				$check_user_id=$mysqli->prepare("SELECT user_id,email,name from user_master where approve_flag='0' and user_id=?");
				$check_user_id->bind_param("i",$user_id);
				$check_user_id->execute();
				$check_user_id->store_result();
				$check_user_id_count=$check_user_id->num_rows;
				if($check_user_id_count <= 0) {
					$record=array('success'=>false,'msg'=>$msgApprovedExist);
					jsonSendEncode($record);
				}
				$check_user_id->bind_result($user_id_get, $email, $name);
				
				$check_user_id->fetch();
		            // $featured_provider    =   1;
				$updatetime     =   date('Y-m-d H:i:s');
		            // update Query
				$approve_flag =1;
				$update_all     =   $mysqli->prepare("UPDATE user_master set approve_flag='1',profile_complete=1, updatetime=? WHERE user_id=?"); 
				$update_all->bind_param("si", $updatetime, $user_id);
				$update_all->execute();
				$update         =   $mysqli->affected_rows;
				if($update<=0){ 
					$record     =   array('success'=>false, 'msg'=>$getApprovedError, 'data'=>array()); 
					jsonSendEncode($record); 
				}

				if ($approve_flag == 1) {
					$active_flag_html = 'your account has been Approve by admin.';
				}
				$postData['fromName']       =   $appName;
				$postData['app_name']       =   $appName;
				$postData['app_logo']       =   $appLogo;
				$postData['app_bg']         =   'app_bg';
				$postData['name']           =   $name;
				$postData['email']          =   $email;
				$postData['mailContent']    = $active_flag_html;
				
				$subject =  "Account Info";
				$postData['mail_msg']       =   $subject;
		            //$postData['Image']=$img_url_user_main.$image;
				$mailBody = mailBodyApprove($postData);
				$mailResponse = mailSend($postData['email'], $postData['fromName'], $subject, $mailBody);

				$user_playerIdArr = array();
				$notification_arr = array();
				
		                    $admin_send = 1; // sender 
		                    $action     =   'Account Approved'; // 
		                    $title      =   "Your Account is approved by admin!"; //English
		                    $title_2    =   $title;
		                    $title_3    =   $title;
		                    $title_4    =   $title;
		                    $message    =   "Your Account is approved by admin";
		                    $message_2  =   $message;
		                    $message_3  =   $message;
		                    $message_4  =   $message;

		                    
		                    $other_user_id = $user_id_get;
		                    $action_id = $user_id_get;
		                    $action_data = array('user_id' => $admin_send, 'other_user_id' => $other_user_id, 'action_id' => $action_id, 'action' => $action);
		                    $notification_arr_get = getNotificationArrSingle($admin_send, $other_user_id, $action, $action_id, $title, $title_2, $title_3, $title_4, $message, $message_2, $message_3, $message_4, $action_data);
		                    if ($notification_arr_get != 'NA') {
		                    	$notification_arr[] = $notification_arr_get;
		                    }
		                    $sendStatus = 0;
		                    
		                    if (empty($notification_arr)) {
		                    	$notification_arr = 'NA';
		                    }
		                    $record         =   array('success'=>true, 'msg'=>$getApproved, 'data'=>array("notification_arr"=>$notification_arr,'sendStatus'=>$sendStatus)); 
		                    jsonSendEncode($record);
		                  }
		                }
		//mark as Approve end





		                function updateUserActiveDeactiveStatus($data)
		                {
		                	global $mysqli;
		                	include_once('language_message.php');
		                	include('mailFunctions.php');
		                	include('site_config.php');
			//print_r($data);exit;
		                	if (empty($data['user_id']) && empty($data['active_flag'])) {
		                		$record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
		                		jsonSendEncode($record);
		                	} else {
		                		$user_id 		= $data['user_id'];
				//$user_id = decode($user_id);
		                		$active_flag 		= $data['active_flag'];
		                		$check_user_id = $mysqli->prepare("SELECT user_id from user_master where delete_flag='0' and user_id=?");
		                		$check_user_id->bind_param("i", $user_id);
		                		$check_user_id->execute();
		                		$check_user_id->store_result();
		                		$check_user_id_count = $check_user_id->num_rows;
		                		if ($check_user_id_count <= 0) {
		                			$record = array('success' => false, 'msg' => $msgUserNotExist, 'data' => array());
		                			jsonSendEncode($record);
		                		}
		                		$check_user = $mysqli->prepare("SELECT user_id,email,name from user_master where delete_flag='0' and user_id=?");
		                		$check_user->bind_param("i", $user_id);
		                		$check_user->execute();
		                		$check_user->store_result();
		                		$check_user_count = $check_user->num_rows;
		                		$check_user->bind_result($user_id, $email, $name);
		                		if ($check_user_count > 0) {
		                			$check_user->fetch();
		                			if(!empty($email)){
		                				if ($active_flag == 1) {
		                					$active_flag_html = 'your account has been Active by admin.';
		                				} else if ($active_flag == 0) {
		                					$active_flag_html = 'your account has been Deactivated by admin for some resons.';
		                				}
		                				$postData['fromName']       =   $appName;
		                				$postData['app_name']       =   $appName;
		                				$postData['app_logo']       =   $appLogo;
		                				$postData['app_bg']         =   'app_bg';
		                				$postData['name']           =   $name;
		                				$postData['email']          =   $email;
		                				$postData['mailContent']    = $active_flag_html;
		                				$postData['approve_flag']   =   $active_flag;
		                				$subject =  "Account Info";
		                				$postData['mail_msg']	    =   $subject;
					//$postData['Image']=$img_url_user_main.$image;
		                				$mailBody =	mailBodyApprove($postData);
		                				$mailResponse =	mailSend($postData['email'], $postData['fromName'], $subject, $mailBody);	
		                			}
		                			
		                		}
		                		$updatetime = date('Y-m-d H:i:s');
		                		$update_all = $mysqli->prepare("UPDATE user_master set active_flag=?, updatetime=? WHERE user_id=?");
		                		$update_all->bind_param("ssi", $active_flag, $updatetime, $user_id);
		                		$update_all->execute();
				//echo 'error='.mysqli_error($mysqli);
		                		$update = $mysqli->affected_rows;
		                		if ($update <= 0) {
		                			$record = array('success' => false, 'msg' => $msgDataNotUpdate, 'data' => array());
		                			jsonSendEncode($record);
		                		}

				// $update_business = $mysqli->prepare("UPDATE business_master set active_flag=?, updatetime=? WHERE user_id=?");
				// $update_business->bind_param("ssi", $active_flag, $updatetime, $user_id);
				// $update_business->execute();
				// //echo 'error='.mysqli_error($mysqli);
				// $update_business_all = $mysqli->affected_rows;

				//$user_id = encode($user_id);
		                		if ($active_flag == '1') {
		                			$active_flag_text = '0';
		                			$active_flag_html = '	<span class="badge rounded-pill bg-success inv-badge">Activate</span>';
		                		} else {
		                			$active_flag_text = '1';
		                			$active_flag_html = '<span class="badge rounded-pill bg-danger inv-badge">Deactivate</span>';
		                		}

		                		$action_html = '

		                		<div class="btn-group">

		                		<button type="button" class="btn btn-primary btn-outline dropdown-toggle float-button-light" id="primary-dropdown-outline" data-bs-toggle="dropdown" aria-expanded="false">

		                		Action

		                		</button>

		                		<ul class="dropdown-menu dropdown-menu-primary" style=" margin: 2px -56px 0;" aria-labelledby="primary-dropdown" role="menu">

		                		<li><a href="view_user.php?id=' . encode($user_id) . '"" class="dropdown-item"><i class="fas fa-eye"></i>View</a></li>



		                		<li><a href="#" data-user-status="' . $active_flag_text . '" data-id="' . $user_id . '"onClick="btnUserActivateDeactivateConfirm(this)" class="dropdown-item"><i class="fas fa-toggle-on"></i>&nbsp;Activate/Deactivate</a>

		                		</li>

		                		</ul>

		                		</div>




		                		
		                		';
		                		if ($active_flag == '1') {
		                			$record = array('success' => true, 'msg' => $msgUserActivatedSuccess, 'data' => array('action_html' => $action_html, 'active_flag_html' => $active_flag_html));
		                			jsonSendEncode($record);
		                		} else if ($active_flag == '0') {
		                			$record = array('success' => true, 'msg' => $msgUserDeactivatedSuccess, 'data' => array('action_html' => $action_html, 'active_flag_html' => $active_flag_html));
		                			jsonSendEncode($record);
		                		}
		                	}
		                }




		                function getUsers($data)
		                {
		                	global $mysqli;
		                	global $onerror;
		                	global $country_code;
		                	include_once('language_message.php');
			//include_once('site_config.php');
			// print_r($data);
		                	if (empty($data['type'])) {
		                		$record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
		                		jsonSendEncode($record);
		                	} else {
		                		$type 		= $data['type'];
		                		$srno = 1;
				//for($i=0; $i<50; $i++){
		                		if ($type == 'all') {
		            // echo "SELECT user_id,f_name,l_name,name,email,mobile,image, active_flag,createtime from user_master where delete_flag='0' and user_type = '1' and profile_complete=1 order by user_id desc";die;
		                			$check_data = $mysqli->prepare("SELECT user_id,name,mobile,email,image, active_flag,createtime,phone_code,user_type,role_id from user_master where delete_flag='0' and user_type = '1'  and profile_complete=1 order by user_id desc");
		                		}
		                		$check_data->execute();
		                		$check_data->store_result();
		                		$check_data_count = $check_data->num_rows;
		                		if ($check_data_count > 0) {
		                			$check_data->bind_result($user_id,  $username, $mobile,$email, $image, $active_flag, $createtime,$phone_code,$user_type,$role);
		                			while ($check_data->fetch()) {
		                				$createtime = date('d-m-Y h:i A', strtotime($createtime));
						//$countrycode = getCountryCode($country_id);
						//$user_id = encode($user_id);
		                				$image_html = '<img  width="50px" src="../webservice/images/' . $image . '" class="rounded-circle circle-border m-b-md img-fix img-responsive" name="profile_image" id="previewholder" style="width: 70px; height: 70px;" alt="" onerror="this.src=' . $onerror . ';" >';

		                				$getRole =getRole($role);
		                				$role_text ='<label class="badge badge-primary">'.$getRole.'</label>';

						// if($role == 0){
						// 	$role_text ='<label class="badge badge-success"></label>';
						// }else{
						// $role_text ='<label class="badge badge-success"></label>';	
						// }


		                				if ($active_flag == '1') {
		                					$active_flag_text = '0';
		                					$active_flag_html = '	<span class="badge rounded-pill bg-success inv-badge">Activate</span>';
		                				} else {
		                					$active_flag_text = '1';
		                					$active_flag_html = '<span class="badge rounded-pill bg-danger inv-badge">Deactivate</span>';
		                				}

		                				if ($user_type == '1') {
		                					
		                					$user_flag_html = '	<span class="badge rounded-pill bg-success inv-badge">Business</span>';
		                				} else {
		                					
		                					$user_flag_html = '<span class="badge rounded-pill bg-info inv-badge">Trade Association</span>';
		                				}
		                				if (empty($email)) {
		                					$email ='NA';
		                				}
		                				if (empty($mobile)) {
		                					$mobile ='NA';
		                				}else{
		                					$mobile =$mobile;
		                				}


		                				$action_html = '

		                				<div class="btn-group">

		                				<button type="button" class="btn btn-primary btn-outline  dropdown-toggle float-button-light" id="primary-dropdown-outline" data-bs-toggle="dropdown" aria-expanded="false">

		                				Action

		                				</button>

		                				<ul class="dropdown-menu dropdown-menu-primary" style=" margin: 2px -56px 0;" aria-labelledby="primary-dropdown" role="menu">

		                				<li><a href="view_user.php?id=' . encode($user_id) . '"" class="dropdown-item"><i class="fa fa-eye"></i>&nbsp;View</a></li>

		                				


		                				<li><a href="#" data-user-status="' . $active_flag_text . '" data-id="' . $user_id . '"onClick="btnUserActivateDeactivateConfirm(this)" class="dropdown-item"><i class="fa fa-toggle-on"></i> &nbsp;Activate/Deactivate</a>

		                				</li>

		                				<li><a href="change_user_password.php?id=' . encode($user_id) . '"" class="dropdown-item"><i class="fa fa-unlock-alt"></i>&nbsp;Change Password</a></li>


		                				<a class="dropdown-item"  href="javascript:void(0)" data-id="' . $user_id . '"  onClick="btnUserDeleteConfirm(this)"><i class="fa fa-trash" "></i>&nbsp;Delete</a>

		                				</ul>

		                				</div>




		                				
		                				';

		                				$user_arr[] = array('srno' => $srno, 'user_id' => $user_id, 'mobile' => $mobile, 'active_flag' => $active_flag_html, 'action' => $action_html, 'createtime' => $createtime, 'username' => $username,'user_type'=>$user_flag_html,'email'=>$email,'image'=>$image_html,'role_text'=>$role_text);
		                				$srno++;
		                			}
		                		}
		                		if (empty($user_arr)) {
		                			$user_arr = array();
		                		}
		                		$record = array('success' => true, 'msg' => $msgDataFound, 'data' => array('user_arr' => $user_arr));
		                		jsonSendEncode($record);
		                	}
		                }






























		                function editAdminProfile($data)
		                {
		                	global $mysqli;
		                	include_once('language_message.php');
			//print_r($data);
		                	if (empty($data['id']) || empty($data['email'])) {
		                		$record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
		                		jsonSendEncode($record);
		                	} else {
		                		$user_id 		= decode($data['id']);
		                		$email 			= trim($data['email']);
		                		$name			= trim($data['name']);
				// $address			= trim($data['address']);
				// $mobile	        = trim($data['mobile']);
				// $fname          = $data['fname'];
				// $lname          = $data['lname'];
				//$gender			= $data['gender'];
				//-------------------------- check user email --------------------------
		                		$check_email_mobile = $mysqli->prepare("SELECT image from user_master where delete_flag='0' and user_id=?");
		                		$check_email_mobile->bind_param("i", $user_id);
		                		$check_email_mobile->execute();
		                		$check_email_mobile->store_result();
		                		$check_email_mobile_count = $check_email_mobile->num_rows;
		                		if ($check_email_mobile_count <= 0) {
		                			$record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
		                			jsonSendEncode($record);
		                		}
		                		$check_email_mobile->bind_result($image_get);
		                		$check_email_mobile->fetch();
		                		if (!empty($_FILES['image']['name'])) {
		                			$user_image	= $_FILES['image'];
					// Code to upload the file starts
		                			$file = $user_image;
		                			$folder_name = '../webservice/images';
		                			$file_type = 'image';
		                			$upload_status = uploadFile($file, $folder_name, $file_type);
		                			if ($upload_status == 'error') {
		                				$record = array('success' => false, 'msg' => $msgErrorFileUpload, 'data' => array());
		                				jsonSendEncode($record);
		                			}
		                			$image = $upload_status;
					// Code to upload the file starts
		                		} else {
		                			$image =  $image_get;
		                		}
		                		$updatetime = date('Y-m-d H:i:s');
		                		$update_all = $mysqli->prepare("UPDATE user_master SET  name=? ,email=?, image=?, updatetime=? WHERE user_id=?");
		                		$update_all->bind_param("ssssi", $name, $email, $image, $updatetime, $user_id);
		                		$update_all->execute();
				//echo 'error='.mysqli_error($mysqli);
		                		$update = $mysqli->affected_rows;
		                		if ($update <= 0) {
		                			$record = array('success' => false, 'msg' => $msgProfileNotUpdate, 'data' => array());
		                			jsonSendEncode($record);
		                		}
		                		$record = array('success' => true, 'msg' => $msgProfileSuccessUpdate, 'data' => array());
		                		jsonSendEncode($record);
		                	}
		                }
		                function editAdminPassword($data)
		                {
		                	global $mysqli;
		                	include_once('language_message.php');
			//print_r($data);
		                	if (empty($data['id']) || empty($data['old_password']) || empty($data['new_password'])) {
		                		$record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
		                		jsonSendEncode($record);
		                	} else {
		                		$user_id 		= decode($data['id']);
		                		$old_password 		= md5($data['old_password']);
		                		$new_password		= md5($data['new_password']);
				//-------------------------- check user email --------------------------
		                		$check_email_mobile = $mysqli->prepare("SELECT password from user_master where delete_flag='0' and user_id=?");
		                		$check_email_mobile->bind_param("i", $user_id);
		                		$check_email_mobile->execute();
		                		$check_email_mobile->store_result();
		                		$check_email_mobile_count = $check_email_mobile->num_rows;
		                		if ($check_email_mobile_count <= 0) {
		                			$record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
		                			jsonSendEncode($record);
		                		}
		                		$check_email_mobile->bind_result($password_get);
		                		$check_email_mobile->fetch();
		                		$password_check = strcasecmp($password_get, $old_password);
		                		if ($password_check != 0) {
		                			$record = array('success' => false, 'msg' => $msgOldPasswordWrong, 'data' => array());
		                			jsonSendEncode($record);
		                		}
		                		$updatetime = date('Y-m-d H:i:s');
		                		$update_all = $mysqli->prepare("UPDATE user_master SET password=?, updatetime=? WHERE user_id=?");
		                		$update_all->bind_param("ssi", $new_password, $updatetime, $user_id);
		                		$update_all->execute();
				//echo 'error='.mysqli_error($mysqli);
		                		$update = $mysqli->affected_rows;
		                		if ($update <= 0) {
		                			$record = array('success' => false, 'msg' => $msgResetPasswordError, 'data' => array());
		                			jsonSendEncode($record);
		                		}

		                		$record = array('success' => true, 'msg' => $msgResetPasswordSuccess, 'data' => array());
		                		jsonSendEncode($record);
		                	}
		                }








		                function getSubadmin($data)
		                {
		                	global $mysqli;
		                	global $onerror;
		                	global $country_code;
		                	include_once('language_message.php');
			//include_once('site_config.php');
			//print_r($data);
		                	if (empty($data['type'])) {
		                		$record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
		                		jsonSendEncode($record);
		                	} else {
		                		$type 		= $data['type'];
		                		$srno = 1;
				//for($i=0; $i<50; $i++){
		                		if ($type == 'all') {
		                			$check_data = $mysqli->prepare("SELECT user_id,f_name,l_name,name,email,mobile,image, active_flag,createtime from user_master where delete_flag='0' and user_type = '2' and profile_complete=1 order by user_id desc");
		                		}
		                		$check_data->execute();
		                		$check_data->store_result();
		                		$check_data_count = $check_data->num_rows;
		                		if ($check_data_count > 0) {
		                			$check_data->bind_result($user_id, $first_name, $l_name, $name, $email, $mobile, $image, $active_flag, $createtime);
		                			while ($check_data->fetch()) {
		                				$createtime = date('d-m-Y h:i A', strtotime($createtime));
						//$countrycode = getCountryCode($country_id);
						//$user_id = encode($user_id);


		                				$image_html = '<img  width="50px" src="../webservice/images/' . $image . '" class="rounded-circle circle-border m-b-md img-fix img-responsive" name="profile_image" id="previewholder" style="width: 70px; height: 70px;" alt="" onerror="this.src=' . $onerror . ';" >';





		                				if ($active_flag == '1') {
		                					$active_flag_text = '0';
		                					$active_flag_html = '	<span class="badge rounded-pill bg-success inv-badge">Activate</span>';
		                				} else {
		                					$active_flag_text = '1';
		                					$active_flag_html = '<span class="badge rounded-pill bg-danger inv-badge">Deactivate</span>';
		                				}




		                				$action_html = '<div class="btn-group">

		                				
		                				<button type="button" class="btn btn-primary dropdown-toggle" data-bs-toggle="dropdown">Action</button>

		                				<div class="dropdown-menu dropdown-menu-end">

		                				

		                				<li><a href="view_subadmin.php?id=' . encode($user_id) . '"" class="dropdown-item"><i class="fa fa-eye"></i>View</a></li>

		                				<li><a href="edit_subadmin.php?id=' . encode($user_id) . '"" class="dropdown-item"><i class="fa fa-edit"></i>Edit</a></li>
		                				

		                				<a class="dropdown-item" href="#" data-user-status="' . $active_flag_text . '" data-id="' . $user_id . '"onClick="btnUserActivateDeactivateConfirm(this)"><i class="fa fa-toggle-on"></i>&nbsp;Activate/Deactivate</a>

		                				<a class="dropdown-item"  data-id="' . $user_id . '" onClick="btnUserDeleteConfirm(this)"><i class="fa fa-trash"></i>&nbsp;Delete</a>

		                				

		                				</div>



		                				</div>
		                				';
		                				$user_arr[] = array('srno' => $srno, 'user_id' => $user_id, 'first_name' => $first_name, 'email' => $email, 'mobile' => $country_code . ' ' . $mobile, 'active_flag' => $active_flag_html, 'action' => $action_html, 'createtime' => $createtime, 'image' => $image_html, 'name' => $name);
		                				$srno++;
		                			}
		                		}
		                		if (empty($user_arr)) {
		                			$user_arr = array();
		                		}
		                		$record = array('success' => true, 'msg' => $msgDataFound, 'data' => array('user_arr' => $user_arr));
		                		jsonSendEncode($record);
		                	}
		                }










		                function mobileCheckadd($data)
		                {
		                	global $mysqli;
		                	include_once('language_message.php');
			//print_r($data);
		                	if (empty($data['mobile'])) {
		                		echo 'false';
		                	} else {
		                		$mobile 		= trim($data['mobile']);
				//$user_id 		= decode($data['id']);
				//-------------------------- check user email --------------------------
		                		$check_email_mobile = $mysqli->prepare("SELECT user_id from user_master where delete_flag='0' and mobile=? ");
		                		$check_email_mobile->bind_param("i", $mobile);
		                		$check_email_mobile->execute();
		                		$check_email_mobile->store_result();
		                		$check_email_mobile_count = $check_email_mobile->num_rows;
		                		if ($check_email_mobile_count > 0) {
		                			echo 'false';
		                		} else {
		                			echo "true";
		                		}
		                	}
		                }











		                function mobileCheckedit($data)
		                {
		                	global $mysqli;
		                	include_once('language_message.php');
			//print_r($data);
		                	if (empty($data['mobile'])) {
		                		echo 'false';
		                	} else {
		                		$mobile 		= trim($data['mobile']);
		                		$service_id 		= decode($data['service_id']);
				//-------------------------- check user email --------------------------
		                		$check_email_mobile = $mysqli->prepare("SELECT service_id from service_master where delete_flag='0' and service_phone_number=? and service_id!=?");
		                		$check_email_mobile->bind_param("ii", $mobile, $service_id);
		                		$check_email_mobile->execute();
		                		$check_email_mobile->store_result();
		                		$check_email_mobile_count = $check_email_mobile->num_rows;
		                		if ($check_email_mobile_count > 0) {
		                			echo 'false';
		                		} else {
		                			echo "true";
		                		}
		                	}
		                }


















		                function updateUserVerifiedStatus($data)
		                {
		                	global $mysqli;
		                	include_once('language_message.php');
		                	include('mailFunctions.php');
		                	include('site_config.php');
			//print_r($data);exit;
		                	if (empty($data['user_id']) && empty($data['active_flag'])) {
		                		$record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
		                		jsonSendEncode($record);
		                	} else {
		                		$user_id 		= $data['user_id'];
				//$user_id = decode($user_id);
		                		$active_flag 		= $data['active_flag'];
		                		$check_user_id = $mysqli->prepare("SELECT user_id from user_master where delete_flag='0' and user_id=?");
		                		$check_user_id->bind_param("i", $user_id);
		                		$check_user_id->execute();
		                		$check_user_id->store_result();
		                		$check_user_id_count = $check_user_id->num_rows;
		                		if ($check_user_id_count <= 0) {
		                			$record = array('success' => false, 'msg' => $msgUserNotExist, 'data' => array());
		                			jsonSendEncode($record);
		                		}
				// $check_user=$mysqli->prepare("SELECT user_id,email,name from user_master where delete_flag='0' and user_id=?");
				// $check_user->bind_param("i",$user_id);
				// $check_user->execute();
				// $check_user->store_result();
				// $check_user_count=$check_user->num_rows;
				// $check_user->bind_result($user_id,$email,$name);
				// if($check_user_count>0){
				// 	$check_user->fetch();
				// 	if($active_flag==1){
				// 		$active_flag_html= 'your account has been Activated by admin.';
				// 	}
				// 	else if($active_flag==0){
				// 		$active_flag_html= 'your account has been Deactivated by admin for some resons.';
				// 	}
				// 	$postData['fromName']       =   'LocalServes App';
				// 	$postData['app_name']       =   $appName;
				// 	$postData['app_logo']       =   $appLogo;
				// 	$postData['app_bg']         =   'app_bg';
				// 	$postData['name']           =   $name;
				// 	$postData['email']          =   $email;
				// 	$postData['mailContent']    =$active_flag_html;
				// 	$postData['approve_flag']   =   $active_flag;
				// 	$subject =  "Account Info";
				// 	$postData['mail_msg']	    =   $subject;
				//        //$postData['Image']=$img_url_user_main.$image;
				// 	$mailBody =	mailBodyApprove($postData);
				// 	$mailResponse =	mailSend($postData['email'],$postData['fromName'], $subject, $mailBody);
				// }
		                		$updatetime = date('Y-m-d H:i:s');
		                		$update_all = $mysqli->prepare("UPDATE user_master set verify_flag=?, updatetime=? WHERE user_id=?");
		                		$update_all->bind_param("isi", $active_flag, $updatetime, $user_id);
		                		$update_all->execute();
				//echo 'error='.mysqli_error($mysqli);
		                		$update = $mysqli->affected_rows;
		                		if ($update <= 0) {
		                			$record = array('success' => false, 'msg' => $msgDataNotUpdate, 'data' => array());
		                			jsonSendEncode($record);
		                		}
				//$user_id = encode($user_id);
		                		



		                		if ($active_flag == '1') {
		                			$record = array('success' => true, 'msg' =>$msgStatusVerify, 'data' => array());
		                			jsonSendEncode($record);
		                		} else if ($active_flag == '0') {
		                			$record = array('success' => true, 'msg' =>$msgStatusUnVerify , 'data' => array());
		                			jsonSendEncode($record);
		                		}
		                	}
		                }

		                function updateUserSuggestedStatus($data)
		                {
		                	global $mysqli;
		                	include_once('language_message.php');
		                	include('mailFunctions.php');
		                	include('site_config.php');
			//print_r($data);exit;
		                	if (empty($data['user_id']) && empty($data['active_flag'])) {
		                		$record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
		                		jsonSendEncode($record);
		                	} else {
		                		$user_id 		= $data['user_id'];
				//$user_id = decode($user_id);
		                		$active_flag 		= $data['active_flag'];
		                		$check_user_id = $mysqli->prepare("SELECT user_id from user_master where delete_flag='0' and user_id=?");
		                		$check_user_id->bind_param("i", $user_id);
		                		$check_user_id->execute();
		                		$check_user_id->store_result();
		                		$check_user_id_count = $check_user_id->num_rows;
		                		if ($check_user_id_count <= 0) {
		                			$record = array('success' => false, 'msg' => $msgUserNotExist, 'data' => array());
		                			jsonSendEncode($record);
		                		}
				// $check_user=$mysqli->prepare("SELECT user_id,email,name from user_master where delete_flag='0' and user_id=?");
				// $check_user->bind_param("i",$user_id);
				// $check_user->execute();
				// $check_user->store_result();
				// $check_user_count=$check_user->num_rows;
				// $check_user->bind_result($user_id,$email,$name);
				// if($check_user_count>0){
				// 	$check_user->fetch();
				// 	if($active_flag==1){
				// 		$active_flag_html= 'your account has been Activated by admin.';
				// 	}
				// 	else if($active_flag==0){
				// 		$active_flag_html= 'your account has been Deactivated by admin for some resons.';
				// 	}
				// 	$postData['fromName']       =   'LocalServes App';
				// 	$postData['app_name']       =   $appName;
				// 	$postData['app_logo']       =   $appLogo;
				// 	$postData['app_bg']         =   'app_bg';
				// 	$postData['name']           =   $name;
				// 	$postData['email']          =   $email;
				// 	$postData['mailContent']    =$active_flag_html;
				// 	$postData['approve_flag']   =   $active_flag;
				// 	$subject =  "Account Info";
				// 	$postData['mail_msg']	    =   $subject;
				//        //$postData['Image']=$img_url_user_main.$image;
				// 	$mailBody =	mailBodyApprove($postData);
				// 	$mailResponse =	mailSend($postData['email'],$postData['fromName'], $subject, $mailBody);
				// }
		                		$updatetime = date('Y-m-d H:i:s');
		                		$update_all = $mysqli->prepare("UPDATE user_master set suggested_flag=?, updatetime=? WHERE user_id=?");
		                		$update_all->bind_param("isi", $active_flag, $updatetime, $user_id);
		                		$update_all->execute();
				//echo 'error='.mysqli_error($mysqli);
		                		$update = $mysqli->affected_rows;
		                		if ($update <= 0) {
		                			$record = array('success' => false, 'msg' => $msgDataNotUpdate, 'data' => array());
		                			jsonSendEncode($record);
		                		}
				//$user_id = encode($user_id);
		                		



		                		if ($active_flag == '1') {
		                			$record = array('success' => true, 'msg' =>$msgStatusSuggested, 'data' => array());
		                			jsonSendEncode($record);
		                		} else if ($active_flag == '0') {
		                			$record = array('success' => true, 'msg' =>$msgStatusUnSuggested , 'data' => array());
		                			jsonSendEncode($record);
		                		}
		                	}
		                }

		                function getDeletedUsers($data)
		                {
		                	global $mysqli;
		                	global $onerror;
		                	global $country_code;
		                	include_once('language_message.php');
			//include_once('site_config.php');
			// print_r($data);
		                	if (empty($data['type'])) {
		                		$record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
		                		jsonSendEncode($record);
		                	} else {
		                		$type 		= $data['type'];
		                		$srno = 1;
				//for($i=0; $i<50; $i++){
		                		if ($type == 'all') {
		            // echo "SELECT user_id,f_name,l_name,name,email,mobile,image, active_flag,createtime from user_master where delete_flag='0' and user_type = '1' and profile_complete=1 order by user_id desc";die;
		                			$check_data = $mysqli->prepare("SELECT user_id,name,mobile,email,image, active_flag,updatetime,phone_code,user_type,delete_reason,role_id from user_master where delete_flag='1' and user_type != '0' and profile_complete=1 order by user_id desc");
		                		}
		                		$check_data->execute();
		                		$check_data->store_result();
		                		$check_data_count = $check_data->num_rows;
		                		if ($check_data_count > 0) {
		                			$check_data->bind_result($user_id,$username, $mobile,$email, $image, $active_flag, $createtime,$phone_code,$user_type,$delete_reason,$role_id);
		                			while ($check_data->fetch()) {
		                				$createtime = date('d-m-Y h:i A', strtotime($createtime));

		                				$getRole =getRole($role_id);
		                				$role_text ='<label class="badge badge-primary">'.$getRole.'</label>';
		                				
		                				$image_html = '<img  width="50px" src="../webservice/images/' . $image . '" class="rounded-circle circle-border m-b-md img-fix img-responsive" name="profile_image" id="previewholder" style="width: 70px; height: 70px;" alt="" onerror="this.src=' . $onerror . ';" >';


		                				if ($active_flag == '1') {
		                					$active_flag_text = '0';
		                					$active_flag_html = '	<span class="badge rounded-pill bg-success inv-badge">Activate</span>';
		                				} else {
		                					$active_flag_text = '1';
		                					$active_flag_html = '<span class="badge rounded-pill bg-danger inv-badge">Deactivate</span>';
		                				}

		                				if ($user_type == '1') {
		                					$active_flag_text = '0';
		                					$user_flag_html = '	<span class="badge rounded-pill bg-success inv-badge">Business</span>';
		                				} else {
		                					
		                					$user_flag_html = '<span class="badge rounded-pill bg-info inv-badge">Trade Association</span>';
		                				}
		                				if (empty($email)) {
		                					$email ='NA';
		                				}
		                				if (empty($mobile)) {
		                					$mobile ='NA';
		                				}else{
		                					$mobile ='+91 '.$mobile;
		                				}


		                				$action_html = '

		                				<div class="btn-group">

		                				<button type="button" class="btn btn-primary btn-outline  dropdown-toggle float-button-light" id="primary-dropdown-outline" data-bs-toggle="dropdown" aria-expanded="false">

		                				Action

		                				</button>

		                				<ul class="dropdown-menu dropdown-menu-primary" style=" margin: 2px -56px 0;" aria-labelledby="primary-dropdown" role="menu">

		                				<li><a href="view_user.php?id=' . encode($user_id) . '"" class="dropdown-item"><i class="fa fa-eye"></i>&nbsp;View</a></li>

		                				


		                				<li><a href="#" data-user-status="' . $active_flag_text . '" data-id="' . $user_id . '"onClick="btnUserActivateDeactivateConfirm(this)" class="dropdown-item"><i class="fa fa-toggle-on"></i> &nbsp;Activate/Deactivate</a>

		                				</li>

		                				</ul>

		                				</div>




		                				
		                				';

		                				$user_arr[] = array('srno' => $srno, 'user_id' => $user_id, 'mobile' => $mobile, 'active_flag' => $active_flag_html, 'action' => $action_html, 'createtime' => $createtime, 'username' => $username,'user_type'=>$user_flag_html,'email'=>$email,'delete_reason'=>$delete_reason,'role_text'=>$role_text,'image'=>$image_html);
		                				$srno++;
		                			}
		                		}
		                		if (empty($user_arr)) {
		                			$user_arr = array();
		                		}
		                		$record = array('success' => true, 'msg' => $msgDataFound, 'data' => array('user_arr' => $user_arr));
		                		jsonSendEncode($record);
		                	}
		                }


		                function editUserPassword($data)
		                {
		                	global $mysqli;
		                	include_once('language_message.php');
		                	include('mailFunctions.php');
		                	include('site_config.php');
		                	

			//print_r($data);exit;
		                	if (empty($data['user_id']) || empty($data['password'])) {
		                		$record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
		                		jsonSendEncode($record);
		                	} else {
		                		$user_id 		= $data['user_id'];
		                		$name =$data['name'];
		                		$email =$data['email'];
		                		$p1 =$data['password'];
		                		$new_password		= md5($data['password']);
				//-------------------------- check user email --------------------------
		                		
		                		$updatetime = date('Y-m-d H:i:s');
		                		$update_all = $mysqli->prepare("UPDATE user_master SET password=?, updatetime=? WHERE user_id=?");
		                		$update_all->bind_param("ssi", $new_password, $updatetime, $user_id);
		                		$update_all->execute();
				//echo 'error='.mysqli_error($mysqli);
		                		$update = $mysqli->affected_rows;
		                		if ($update <= 0) {
		                			$record = array('success' => false, 'msg' => $msgResetPasswordError, 'data' => array());
		                			jsonSendEncode($record);
		                		}


		                		$active_flag_html = 'your account password has been changed by admin!';
		                		
		                		$postData['fromName']       =   $appName;
		                		$postData['app_name']       =   $appName;
		                		$postData['app_logo']       =   $appLogo;
		                		$postData['app_url']       =   $app_url;
		                		$postData['app_bg']         =   'app_bg';
		                		$postData['name']           =   $name;
		                		$postData['password']           =   $p1;
		                		$postData['email']          =   $email;
		                		$postData['mailContent']    = $active_flag_html;
		                		
		                		$subject =  "Account Info";
		                		$postData['mail_msg']	    =   $subject;
					//$postData['Image']=$img_url_user_main.$image;
		                		$mailBody =	mailBodyChangePassword($postData);
		                		$mailResponse =	mailSend($postData['email'], $postData['fromName'], $subject, $mailBody);	

		                		$record = array('success' => true, 'msg' => $msgResetPasswordSuccess, 'data' => array());
		                		jsonSendEncode($record);
		                	}
		                }


		                function equipmentCheckadd($data)
		                {
		                	global $mysqli;
		                	include_once('language_message.php');
			//print_r($data);
		                	if (empty($data['name'])) {
		                		echo 'false';
		                	} else {
		                		$name 		= $data['name'];
		                		$etype 		= $data['etype'];
		                		$eqno 		= $data['eq_no'];
				//$user_id 		= decode($data['id']);
				//-------------------------- check user email --------------------------
		                		$check_email_mobile = $mysqli->prepare("SELECT equipment_id from equipment_master where delete_flag='0' and folder_no=? and equipment_name=? and equipment_type_id=? ");
		                		$check_email_mobile->bind_param("ssi", $eqno,$name,$etype);
		                		$check_email_mobile->execute();
		                		$check_email_mobile->store_result();
		                		$check_email_mobile_count = $check_email_mobile->num_rows;
		                		if ($check_email_mobile_count > 0) {
		                			echo 'false';
		                		} else {
		                			echo "true";
		                		}
		                	}
		                }

		                function equipmentCheckEdit($data)
		                {
		                	global $mysqli;
		                	include_once('language_message.php');
			//print_r($data);
		                	if (empty($data['name'])) {
		                		echo 'false';
		                	} else {
		                		$name 		= trim($data['name']);
		                		$etype =$data['etype'];
		                		$equipment_id 		= $data['id'];
		                		$eqno 		= $data['eq_no'];
				//-------------------------- check user email --------------------------
		                		$check_email_mobile = $mysqli->prepare("SELECT equipment_id from equipment_master where delete_flag='0' and folder_no=? and equipment_name=? and equipment_type_id=? and equipment_id!=?");
		                		$check_email_mobile->bind_param("ssii", $eqno,$name,$etype, $equipment_id);
		                		$check_email_mobile->execute();
		                		$check_email_mobile->store_result();
		                		$check_email_mobile_count = $check_email_mobile->num_rows;
		                		if ($check_email_mobile_count > 0) {
		                			echo 'false';
		                		} else {
		                			echo "true";
		                		}
		                	}
		                }


		                   function inspectiontitleCheckadd($data)
		                {
		                	global $mysqli;
		                	include_once('language_message.php');
			//print_r($data);
		                	if (empty($data['ititle'])) {
		                		echo 'false';
		                	} else {
		                		$ititle 		= $data['ititle'];
		                		$etype 		= $data['etype'];
				//$user_id 		= decode($data['id']);
				//-------------------------- check user email --------------------------
		                		$check_email_mobile = $mysqli->prepare("SELECT inspection_id from inspection_master where delete_flag='0' and inspection_title=? and equipment_type_id=? ");
		                		$check_email_mobile->bind_param("si", $ititle,$etype);
		                		$check_email_mobile->execute();
		                		$check_email_mobile->store_result();
		                		$check_email_mobile_count = $check_email_mobile->num_rows;
		                		if ($check_email_mobile_count > 0) {
		                			echo 'false';
		                		} else {
		                			echo "true";
		                		}
		                	}
		                }


		                 function inspectiontitleCheckEdit($data)
		                {
		                	global $mysqli;
		                	include_once('language_message.php');
			//print_r($data);
		                	if (empty($data['ititle'])) {
		                		echo 'false';
		                	} else {
		                		$ititle 		= $data['ititle'];
		                		$etype =$data['etype'];
		                		$inspection_id 		= $data['id'];
				//-------------------------- check user email --------------------------
		                		$check_email_mobile = $mysqli->prepare("SELECT inspection_id from inspection_master where delete_flag='0' and inspection_title=? and equipment_type_id=? and inspection_id!=?");
		                		$check_email_mobile->bind_param("sii", $ititle,$etype, $inspection_id);
		                		$check_email_mobile->execute();
		                		$check_email_mobile->store_result();
		                		$check_email_mobile_count = $check_email_mobile->num_rows;
		                		if ($check_email_mobile_count > 0) {
		                			echo 'false';
		                		} else {
		                			echo "true";
		                		}
		                	}
		                }

		                    function maintainanceCheckadd($data)
		                {
		                	global $mysqli;
		                	include_once('language_message.php');
			//print_r($data);
		                	if (empty($data['ititle'])) {
		                		echo 'false';
		                	} else {
		                		$ititle 		= $data['ititle'];
		                		$etype 		= $data['etype'];
		                		$equipment_id		= $data['equipment'];
				//$user_id 		= decode($data['id']);
				//-------------------------- check user email --------------------------
		                		$check_email_mobile = $mysqli->prepare("SELECT maintainance_id from maintainance_master where delete_flag='0' and maintainance_title=? and equipment_type_id=?  and equipment_id =?");
		                		$check_email_mobile->bind_param("sii", $ititle,$etype,$equipment_id);
		                		$check_email_mobile->execute();
		                		$check_email_mobile->store_result();
		                		$check_email_mobile_count = $check_email_mobile->num_rows;
		                		if ($check_email_mobile_count > 0) {
		                			echo 'false';
		                		} else {
		                			echo "true";
		                		}
		                	}
		                }


		                    function maintainanceCheckEdit($data)
		                {
		                	global $mysqli;
		                	include_once('language_message.php');
			//print_r($data);exit;
		                	if (empty($data['ititle'])) {
		                		echo 'false';
		                	} else {
		                		$ititle 		= $data['ititle'];
		                		$etype =$data['etype'];
		                		$maintainance_id 		= $data['id'];
		                		$equipment_id		= $data['equipment'];
				//-------------------------- check user email --------------------------
		                		$check_email_mobile = $mysqli->prepare("SELECT maintainance_id from maintainance_master where delete_flag='0' and maintainance_title=? and equipment_type_id=? and equipment_id =? and maintainance_id!=?");
		                		$check_email_mobile->bind_param("siii", $ititle,$etype,$equipment_id, $maintainance_id);
		                		$check_email_mobile->execute();
		                		$check_email_mobile->store_result();
		                		$check_email_mobile_count = $check_email_mobile->num_rows;
		                		if ($check_email_mobile_count > 0) {
		                			echo 'false';
		                		} else {
		                			echo "true";
		                		}
		                	}
		                }


		                 function inspectionTypeCheckadd($data)
		                {
		                	global $mysqli;
		                	include_once('language_message.php');
			//print_r($data);
		                	if (empty($data['ins_type'])) {
		                		echo 'false';
		                	} else {
		                		$ins_type 		= $data['ins_type'];
		                	
				//-------------------------- check user email --------------------------
		                		$check_email_mobile = $mysqli->prepare("SELECT inspection_type_id from inspection_type_master where delete_flag='0' and inspection_type=?  ");
		                		$check_email_mobile->bind_param("s", $ins_type);
		                		$check_email_mobile->execute();
		                		$check_email_mobile->store_result();
		                		$check_email_mobile_count = $check_email_mobile->num_rows;
		                		if ($check_email_mobile_count > 0) {
		                			echo 'false';
		                		} else {
		                			echo "true";
		                		}
		                	}
		                }



		                 function inspectiontypeCheckEdit($data)
		                {
		                	global $mysqli;
		                	include_once('language_message.php');
			//print_r($data);exit;
		                	if (empty($data['ins_type'])) {
		                		echo 'false';
		                	} else {
		                		$ins_type 		= $data['ins_type'];
		                	
		                		$inspection_id 		= decode($data['id']);
				//-------------------------- check user email --------------------------
		                		$check_email_mobile = $mysqli->prepare("SELECT inspection_type_id from inspection_type_master where delete_flag='0' and inspection_type=?  and inspection_type_id!=?");
		                		$check_email_mobile->bind_param("si", $ins_type,$inspection_id);
		                		$check_email_mobile->execute();
		                		$check_email_mobile->store_result();
		                		$check_email_mobile_count = $check_email_mobile->num_rows;
		                		if ($check_email_mobile_count > 0) {
		                			echo 'false';
		                		} else {
		                			echo "true";
		                		}
		                	}
		                }

		                function deleteUser1($data)
{
	global $mysqli;
	include_once('language_message.php');
	//print_r($data);
	if (empty($data['user_id'])) {
		$record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
		jsonSendEncode($record);
	} else {
		$user_id 		= decode($data['user_id']);
		//$user_id = decode($user_id);
		$check_user_id = $mysqli->prepare("SELECT user_id from user_master where delete_flag='0' and user_id=?");
		$check_user_id->bind_param("i", $user_id);
		$check_user_id->execute();
		$check_user_id->store_result();
		$check_user_id_count = $check_user_id->num_rows;
		if ($check_user_id_count <= 0) {
			$record = array('success' => false, 'msg' => $msgUserNotExist, 'data' => array());
			jsonSendEncode($record);
		}
		$updatetime = date('Y-m-d H:i:s');
		$update_all = $mysqli->prepare("UPDATE user_master set delete_flag='1', updatetime=? WHERE user_id=?");
		$update_all->bind_param("si", $updatetime, $user_id);
		$update_all->execute();
		//echo 'error='.mysqli_error($mysqli);
		$update = $mysqli->affected_rows;
		if ($update <= 0) {
			$record = array('success' => false, 'msg' => $msgUserDeleteError, 'data' => array());
			jsonSendEncode($record);
		}
		$record = array('success' => true, 'msg' =>$SubadminDelete, 'data' => array());
		jsonSendEncode($record);
	}
}





