<?php
include('config.php');
include('common_functions.php');
include('common_functions_app.php');
function getEditAdminProfile($data)
{
  global $mysqli;
  include('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $user_id = decode($data['id']);
    $user_arr = array();
    $check_data = $mysqli->prepare("SELECT user_id,f_name,l_name, name, email ,mobile, gender,address, image from user_master where delete_flag='0' and user_type IN(0,1,2) and user_id=?");
    $check_data->bind_param("i", $user_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($user_id, $fname, $lname, $name, $email, $mobile, $gender, $address, $image);
      $check_data->fetch();
      $user_arr = array('user_id' => $user_id, 'fname' => $fname, 'lname' => $lname, 'name' => $name, 'email' => $email, 'address' => $address, 'mobile' => $mobile, 'gender' => $gender, 'image' => $image);


      $record = array('success' => true, 'msg' => $msgDataFound, 'data' => $user_arr);
      return jsonSendEncodeAdmin($record);
    }
  }
}
function getDashboard($data)
{
  global $mysqli;
  include('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $user_id = decode($data['id']);



     $totalUser1 = getusercountdetail1();
    // $totalUser2 = getusercountdetail2();
    

    // $totalContact = getcontactdetails();
     $totalCat = gettotalCategory();
    // $totalSize = getSizecountdetail();
    // $totalColor = getColorcountdetail();
    // $totalArea = getAreacountdetail();
    // $totalEvent = getEventcountdetail();
    // $totalGroup = getGroupCount();

    //  $totalSubscribeUser = getSubcribeusercountdetail();


    // $totalFeed =10;
   

    $dashboard_arr = array();
     $dashboard_arr = array('count_1' => $totalUser1,'count_2'=>$totalCat);
    $record = array('success' => true, 'msg' => $msgDataFound, 'data' => $dashboard_arr);
    return jsonSendEncodeAdmin($record);
  }
}


function getContent($data)
{
  global $mysqli;
  include('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $user_id = decode($data['id']);
    // echo "SELECT content_id, content_type,content,content_1 FROM content_master where delete_flag='0'";die;
    $select_about = $mysqli->prepare("SELECT content_id, content_type,content,content_1 FROM content_master where delete_flag='0' ");
    $select_about->execute();
    $select_about->store_result();
    $select_about_all = $select_about->num_rows;
    if ($select_about_all > 0) {
      $select_about->bind_result($content_id, $content_type, $content, $content_1);
      while ($select_about->fetch()) {
        $content_arr[] = array('content_id' => $content_id, 'content_type' => $content_type, 'content' => $content, 'content_1' => $content_1);
      }
    }
    if (empty($content_arr)) {
      $content_arr = 'NA';
    }
    $record = array('success' => true, 'msg' => $msgDataFound, 'data' => $content_arr);
    return jsonSendEncodeAdmin($record);
  }
}
function getBroadcast($data)
{
  global $mysqli;
  global $country_code;
  include('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
     
    $user_id = decode($data['id']);
    $select_about = $mysqli->prepare("SELECT user_id, username,email ,mobile,phone_code FROM user_master where delete_flag=0 and user_type='1' and profile_complete=1 ");
    $select_about->execute();
    $select_about->store_result();
    $select_about_all = $select_about->num_rows;
    if ($select_about_all > 0) {
      $select_about->bind_result($user_id, $username, $email,$mobile,$phone_code);
      while ($select_about->fetch()) {
        $user_arr[] = array('user_id' => $user_id, 'name' => $username, 'mobile' =>  $mobile , 'email'=>$email);
      }
    }
    if (empty($user_arr)) {
      $user_arr = 'NA';
    }
    $select_shop = $mysqli->prepare("SELECT user_id, username,email,mobile FROM user_master where delete_flag=0 and user_type='2' and profile_complete=1");
    $select_shop->execute();
    $select_shop->store_result();
    $select_shop_all = $select_shop->num_rows;
    if ($select_shop_all > 0) {
      $select_shop->bind_result($user_id, $username, $email, $mobile);
      while ($select_shop->fetch()) {
        $store_arr[] = array('user_id' => $user_id, 'name' => $username, 'email' => $email, 'mobile' =>  $mobile);
      }
    }
    if (empty($store_arr)) {
      $store_arr = 'NA';
    }

    $select_shop = $mysqli->prepare("SELECT user_id, username,email,mobile FROM user_master where delete_flag=0 and user_type='3' and profile_complete=1");
    $select_shop->execute();
    $select_shop->store_result();
    $select_shop_all = $select_shop->num_rows;
    if ($select_shop_all > 0) {
      $select_shop->bind_result($user_id, $name, $email, $mobile);
      while ($select_shop->fetch()) {
        $driver_arr[] = array('user_id' => $user_id, 'name' => $name, 'email' => $email, 'mobile' => '+'.$phone_code . ' ' . $mobile);
      }
    }
    if (empty($driver_arr)) {
      $driver_arr = 'NA';
    }
    $record = array('success' => true, 'msg' => $msgDataFound, 'data' => array('user_arr' => $user_arr, 'store_arr' => $store_arr, 'driver_arr' => $driver_arr));
    return jsonSendEncodeAdmin($record);
  }
}
function getViewUsers($data)
{
  global $mysqli;
  include('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $user_id = decode($data['id']);
    $user_arr = array();
    $check_data = $mysqli->prepare("SELECT `user_id`, `email`, `location`, `latitude`, `longitude`, `mobile`, `image`, `name`,
     `f_name`,`l_name`, `dob`, `gender`, `language_id`, `about_me`, `active_flag`, `approved_unapproved`, `user_signup_time`, `createtime` FROM `user_master` where delete_flag='0'
     and user_type = '1' and user_id=?");
    $check_data->bind_param("i", $user_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($user_id, $email, $location, $latitude, $longitude, $mobile, $image, $name, $f_name, $l_name, $dob, $gender, $language_id, $about_me, $active_flag, $approved_unapproved, $user_signup_time, $createtime);
      $check_data->fetch();
      $createtime = date('Y-m-d h:i A', strtotime($createtime));
      $user_arr = array(
        'user_id' => $user_id, 'name' => $name, 'f_name' => $f_name, 'l_name' => $l_name, 'email' => $email, 'mobile' => $mobile, 'gender' => $gender,
        'image' => $image, 'dob' => $dob, 'location' => $location, 'about_me' => $about_me, 'active_flag' => $active_flag, 'createtime' => $createtime
      );
    }
    $record = array('success' => true, 'msg' => $msgDataFound, 'data' => array('user_arr' => $user_arr));
    return jsonSendEncodeAdmin($record);
  }
}
//----------------------get category details-------------------------------------//

//------------------------get user data ---------------------------------------//
function getViewUsersData($data)
{
  //error_reporting(0);
  global $mysqli;
  global $onerror;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $user_id = decode($data['id']);
    $user_arr = array();
    
    $check_data = $mysqli->prepare("SELECT `user_id`, `user_type`,`email`, `password`, `image`, `phone_code`, `mobile`, `otp`, `otp_verify`, `gender`, `dob`, `latitude`, `longitude`, `address`, `profile_complete`, `active_flag`, `notification_status`,  `createtime`,`name`,`role_id`,`delete_reason` FROM `user_master` WHERE   user_id=?");
    $check_data->bind_param("i", $user_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($user_id, $user_type, $email, $password, $image, $phone_code, $mobile, $otp, $otp_verify, $gender, $dob, $latitude, $longitude, $address, $profile_complete,  $active_flag, $notification_status, $createtime,$name,$role_id,$delete_reason);
      // $check_data->bind_result($user_id,$bio,$innocence_project_id,$lead_attorney,$acknowledge_box,$mobile,$email,$name,$image,$active_flag,$createtime);
      $check_data->fetch();

      $getRole =getRole($role_id);
        $role_text ='<label class="badge badge-primary">'.$getRole.'</label>';

      if ($user_type == '1') {
          $active_flag_text = '0';
          $user_flag_html = '<span class="badge rounded-pill bg-success inv-badge">Business</span>';
        } else {
          
          $user_flag_html = '<span class="badge rounded-pill bg-info inv-badge">Trade Association</span>';
        }
      
      
      

      
        
    
   
    


      

      

      $createtime = date('d-m-Y h:i A', strtotime($createtime));
    
     

      $image_html = '<img  width="50px" src="../webservice/images/' . $image . '" class="rounded-circle circle-border m-b-md img-fix img-responsive" name="profile_image" id="previewholder" style="width: 70px; height: 70px;" alt="" onerror="this.src=' . $onerror . ';" >';
        
     

     

      


       if($active_flag == '1'){
          $active_flag_text = '0';
          $active_flag_html = ' <a class="badge rounded-pill bg-success inv-badge" >Active</a>';
        }else{
          $active_flag_text = '1';
          $active_flag_html = '<a class="badge rounded-pill bg-danger inv-badge" >Deactivated</a>';
        }

      

     

        if (empty($email)) {
            $email ='NA';
        }
        if (empty($mobile)) {
            $mobile ='NA';
        }else{
          $mobile =$mobile;
        }


  

    
 $user_arr = array('user_id'=>$user_id ,'delete_reason'=>$delete_reason,'name' => $name, 'email' => $email, 'mobile' =>$mobile, 'image' => $image, 'createtime' => $createtime, 'active_flag' => $active_flag_html,'role_text'=>$role_text);
  
  
     
    }
    $record = array('success' => true, 'msg' => '', 'data' => $user_arr);
    return jsonSendEncodeAdmin($record);
  }
}

function getViewMomentData($data)
{
  //error_reporting(0);
  global $mysqli;
  global $onerror;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $moment_id = decode($data['id']);
    $user_arr = array();
    
    $check_data = $mysqli->prepare("SELECT `moment_id`, `user_id`, `moment_type`, `description`, `image_video`, `video_thumbnail`,  `createtime`, `updatetime` FROM `moment_master` WHERE  delete_flag='0' and moment_id=?");
    $check_data->bind_param("i", $moment_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($moment_id, $user_id, $moment_type, $description, $image_video, $video_thumbnail, $createtime, $updatetime);
      $check_data->fetch();

      $createtime = date('d-m-Y h:i A', strtotime($createtime));
      $updatetime = date('d-m-Y h:i A', strtotime($updatetime));
        $userDetails = getUserDetails($user_id);
        $userName = $userDetails['name'];     

        $totalLikes = getlikesdetails($moment_id);



        if ($moment_type == 0) {
          $status = "'img'";
          $image_html = '<div href="#img_view" style="text-align: center;">
                    <a href="#img_view">
                    <img  width="50px" src="../webservice/images/' . $image_video . '" class="rounded-circle circle-border m-b-md img-fix img-responsive" name="profile_image" id="previewholder" style="width: 70px; height: 70px;" onerror="this.src=' . $onerror . ';"alt=""  onclick="view_img(this,' . $status . ')">
                           <div class="open_my_popup" id="img_view">
                          <div class="imgae_view_bg"></div>
                          <div class="view_popup"> <img src="" id="image_here" class="image_here" /> </div>
                           <a class="close_my_popup" onclick="closePopup();"><img src="assets/images/close.png" /></a></div>
                           </a>
                       </div>';
        } else {

          $status = "'video'";
          $image_html = '<div href="#video_view" style="text-align: center;">
                    <a href="#video_view">


                            <video width="50px"  height="50px" class=" circle-border m-b-md img-fix img-responsive" name="profile_image" id="previewholder" style="width: 250px; height: 250px;" onerror="this.src=' . $onerror . ';"alt=""  onclick="view_img(this,' . $status . ')" controls>
                              <source src="../webservice/videos/' . $image_video . '" type="video/mp4">
                              
                              
                            </video>

                           <div class="open_my_popup" id="video_view">
                          <div class="imgae_view_bg"></div>
                          <div class="view_popup"> <img src="" id="image_here" class="image_here" /> </div>
                           <a class="close_my_popup" onclick="closePopup();"><img src="assets/images/close.png" /></a></div>
                           </a>
                       </div>';
        }

      $user_arr = array('moment_id' => $moment_id, 'userName' => $userName,'moment_type' => $moment_type, 'description' => $description, 'image_video' => $image_html, 'video_thumbnail' => $video_thumbnail, 'createtime' => $createtime, 'updatetime' => $updatetime, 'totalLikes' => $totalLikes);
    }
    $record = array('success' => true, 'msg' => '', 'data' => $user_arr);
    return jsonSendEncodeAdmin($record);
  }
}

function getViewHostData($data)
{
  //error_reporting(0);
  global $mysqli;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $user_id = decode($data['id']);
    $user_arr = array();
    
    $check_data = $mysqli->prepare("SELECT `user_id`, `user_type`, `login_type`, `login_type_first`, `signup_step`, `facebook_id`, `google_id`, `twitter_id`, `instagram_id`, `apple_id`, `f_name`, `l_name`, `name`, `email`, `password`, `image`, `phone_code`, `mobile`, `otp`, `otp_verify`, `gender`, `dob`, `latitude`, `longitude`, `address`, `profile_complete`, `active_flag`, `notification_status`, `language_id`, `delete_flag`, `createtime`, `updatetime`, `mysqltime`, `delete_reason` FROM `user_master` WHERE  delete_flag='0' and user_id=? and user_type=2");
    $check_data->bind_param("i", $user_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($user_id, $user_type, $login_type, $login_type_first, $signup_step, $facebook_id, $google_id, $twitter_id, $instagram_id, $apple_id, $f_name, $l_name, $name, $email, $password, $image, $phone_code, $mobile, $otp, $otp_verify, $gender, $dob, $latitude, $longitude, $address, $profile_complete,  $active_flag, $notification_status, $language_id, $delete_flag, $createtime, $updatetime, $mysqltime, $delete_reason);
      // $check_data->bind_result($user_id,$bio,$innocence_project_id,$lead_attorney,$acknowledge_box,$mobile,$email,$name,$image,$active_flag,$createtime);
      $check_data->fetch();

      $createtime = date('d-m-Y h:i A', strtotime($createtime));
      // $innocence_project_name = getInnocenceName($innocence_project_id);


      if ($active_flag == '1') {
        $active_flag_text = '0';
        $active_flag_html = ' <span class="badge rounded-pill bg-success inv-badge">Activate</span>';
      } else {
        $active_flag_text = '1';
        $active_flag_html = '<span class="badge rounded-pill bg-danger inv-badge">Deactivate</span>';
      }

        if (empty($email)) {
            $email ='NA';
        }




      $user_arr = array('name' => $name, 'email' => $email, 'mobile' => $mobile, 'image' => $image, 'createtime' => $createtime, 'active_flag' => $active_flag_html);
    }
    $record = array('success' => true, 'msg' => '', 'data' => $user_arr);
    return jsonSendEncodeAdmin($record);
  }
}
function getViewEbookData($data)
{
  //error_reporting(0);
  global $mysqli;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $ebook_id = decode($data['id']);
    // print_r($ebook_id);die;
    $user_arr = array();

    $check_data = $mysqli->prepare("SELECT `title`, `descriptions`, `image`, `price`, `pdf_url`, `createtime` FROM `ebook_master` WHERE  delete_flag='0' and ebook_id=?");
    $check_data->bind_param("i", $ebook_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($title, $descriptions, $image, $price, $pdf_url, $createtime);
      $check_data->fetch();
      $createtime = date('d-m-Y h:i A', strtotime($createtime));

      $user_arr = array('title' => $title, 'descriptions' => $descriptions, 'image' => $image, 'price' => $price, 'pdf_url' => $pdf_url, 'createtime' => $createtime);
    }
    $record = array('success' => true, 'msg' => '', 'data' => $user_arr);
    return jsonSendEncodeAdmin($record);
  }
}
function getViewEbookTrainingData($data)
{
  //error_reporting(0);
  global $mysqli;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $ebook_training_id = decode($data['id']);
    // print_r($ebook_id);die;
    $user_arr = array();

    $check_data = $mysqli->prepare("SELECT `ebook_id`, `training_type`, `description`, `image`, `createtime`, `updatetime`, `recommend_status`, `exercise_training_type`, `max_no_of_player`, `min_no_of_player`, `selller_type`, `tactical`, `informational`, `conditional`, `exercise_image`, `focus`, `matchfield`,rules FROM `ebook_training_master` WHERE  delete_flag='0' and ebook_training_id=?");
    $check_data->bind_param("i", $ebook_training_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($ebook_id, $training_type, $description, $image, $createtime, $updatetime,$recommend_status, $exercise_training_type, $max_no_of_player, $min_no_of_player, $selller_type,$tactical, $informational, $conditional, $exercise_image, $focus, $matchfield, $rules);
      $check_data->fetch();
      $createtime = date('d-m-Y h:i A', strtotime($createtime));
if ($training_type==0) {
$training='Other';
}else{
$training='Ebook';
}
if ($recommend_status==1) {
$recommend_status_get='Yes';
}else{
$recommend_status_get='No';
}
$get_ebook_name = get_ebook_name($ebook_id);

      $user_arr = array('ebook_id' => $get_ebook_name, 'training_type' => $training, 'description' => $description, 'image' => $image, 'createtime' => $createtime, 'updatetime' => $updatetime, 'recommend_status' => $recommend_status_get, 'exercise_training_type' => $exercise_training_type, 'max_no_of_player' => $max_no_of_player, 'min_no_of_player' => $min_no_of_player, 'selller_type' => $selller_type, 'tactical' => $tactical, 'informational' => $informational, 'conditional' => $conditional, 'exercise_image' => $exercise_image, 'focus' => $focus, 'matchfield' => $matchfield, 'rules' => $rules);
    }
    $record = array('success' => true, 'msg' => '', 'data' => $user_arr);
    return jsonSendEncodeAdmin($record);
  }
}




//---------------------------------get contact us details by id starts------------------------------------//
function getContactUsDataById($data)
{
  global $mysqli;
  global $onerror;
  include_once('language_message.php');
  if (empty($_GET['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $contact_id = decode($_GET['id']);
    $srno = 1;
    $check_data = $mysqli->prepare("SELECT  `user_id`, `name`,`email`,`message` FROM `contact_us_master` WHERE delete_flag='0' and contact_id=? ");
    $check_data->bind_param("i", $contact_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count > 0) {
      $check_data->bind_result($user_id, $name, $email, $message);
      $check_data->fetch();
      $user_arr = array('srno' => $srno, 'contact_id' => $contact_id, 'user_id' => $user_id, 'name' => $name, 'email' => $email, 'message' => $message);
    }
    if (empty($user_arr)) {
      $user_arr = array();
    }
    $record = array('success' => true, 'data' => $user_arr);
    return jsonSendEncodeAdmin($record);
  }
}
//------------------------get user data ---------------------------------------//



//================new code starts===============================//



function getViewFeedData($data)
{
  //error_reporting(0);
  global $mysqli;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $post_id = decode($data['id']);
    $channel_arr = array();
    $check_data = $mysqli->prepare("SELECT `post_id`, `user_id`, `description`,`createtime` FROM `post_master`  where   delete_flag='0'  and post_id=?");
    $check_data->bind_param("i", $post_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($post_id, $user_id, $description, $createtime);
      $check_data->fetch();

      $createtime = date('d-m-Y h:i A', strtotime($createtime));

      $feed_image_arr = getFeedImage($feed_id);



      // $user_id = encode($user_id);

      $userData = getBusinessDetails($user_id);
      $userName = $userData['business_name'];
      $userEmail = $userData['business_email'];
      $category_name = $userData['category_id'];
      $userimage = $userData['profile_image'];
      $usermobile = $userData['description'];

      $category = getCategoryName($category_name);

      // $NoofLikes =getNoofLikes($feed_id);
      // $NoofComments =getNoofComments($feed_id);




      $action_html = '

                  <div class="btn-group">

                    <button type="button" class="btn btn-primary btn-outline dropdown-toggle float-button-light" id="primary-dropdown-outline" data-bs-toggle="dropdown" aria-expanded="false">

                      Action

                    </button>

                                                    <ul class="dropdown-menu dropdown-menu-primary" style=" margin: 2px -56px 0;" aria-labelledby="primary-dropdown" role="menu">

                                                        <li><a href="view_jobs.php?id=' . encode($job_id) . '"" class="dropdown-item"><i class="fas fa-eye"></i>View</a></li>



                                                        

                                                    </ul>

                                                </div>




      
';
      $feed_arr = array('srno' => $srno, 'feed_id' => $post_id, 'userName' => $userName, 'userEmail' => $userEmail, 'NoofLikes' => $NoofLikes, 'NoofComments' => $NoofComments, 'action' => $action_html, 'createtime' => $createtime, 'description' => $description, 'feed_image_arr' => $feed_image_arr, 'userimage' => $userimage, 'usermobile' => $usermobile, 'category' => $category);
      $srno++;
    }
    $record = array('success' => true, 'msg' => $msgDataFound, 'data' => $feed_arr);
    return jsonSendEncodeAdmin($record);
  }
}


// function getViewBuisnessData($data) {
//       //error_reporting(0);
//       global $mysqli;
//       include_once('language_message.php');
//       // print_r($data);exit();
//       if(empty($data['id'])) {
//         $record=array('success'=>false, 'msg'=>$msgEmptyAll, 'data'=>array());
//        return jsonSendEncodeAdmin($record);
//       } else {
//          $business_id = decode($data['id']);
//         $channel_arr = array();

//         // echo "SELECT `business_id`, `user_id`, `business_name`, `business_phone`, `description`, `createtime` FROM business_master  where   delete_flag='0'  and business_id=?";
//         $check_data=$mysqli->prepare("SELECT  `user_id`, `business_name`, `business_phone`, `business_email`, `description`, `address`, `latitude`, `longitude`, `status`, `createtime`,  `category_id` FROM `business_master`   where   delete_flag='0'  and business_id=?");
//         $check_data->bind_param("i",$business_id);
//         $check_data->execute();
//         $check_data->store_result();
//         $check_data_count=$check_data->num_rows;
//         if($check_data_count <=0) {
//           $record=array('success'=>false,'msg'=>$msgInvalidId,'data'=>array());
//           return jsonSendEncodeAdmin($record);
//         }else{
//           $check_data->bind_result($user_id,$business_name,$business_phone,$business_email,$description,$address,$latitude,$longitude,$status,$createtime,$category_id,$business_id);
//           $check_data->fetch();

//           $createtime=date('d-m-Y h:i A',strtotime($createtime));

//            // $feed_image_arr =getFeedImage($feed_id);



//         // $user_id = encode($user_id);

//         $userData =getUserDetails($user_id);
//         $userName=$userData['name'];
//         $userEmail=$userData['email'];
//         $userimage=$userData['image'];

//         $usermobile=$userData['mobile'];



//         // $NoofLikes =getNoofLikes($feed_id);
//         // $NoofComments =getNoofComments($feed_id);




//         // $action_html = '

//         // <div class="btn-group">

//         //                                             <button type="button" class="btn btn-primary btn-outline dropdown-toggle float-button-light" id="primary-dropdown-outline" data-bs-toggle="dropdown" aria-expanded="false">

//         //                                                 Action

//         //                                             </button>

//         //                                             <ul class="dropdown-menu dropdown-menu-primary" style=" margin: 2px -56px 0;" aria-labelledby="primary-dropdown" role="menu">

//         //                                                 <li><a href="view_buisness.php?id='.encode($business_id).'"" class="dropdown-item"><i class="fas fa-eye"></i>View</a></li>





//         //                                             </ul>

//         //                                         </div>';
//          $feed_arr = array('srno'=>$srno, 'business_id'=>$business_id,'userName'=>$userName,'userEmail'=>$userEmail, 'business_name'=>$business_name, 'business_phone'=>$business_phone, 'action'=>$action_html, 'createtime'=>$createtime,'description'=>$description,'feed_image_arr'=>$feed_image_arr,'userimage'=>$userimage,'usermobile'=>$usermobile,'email'=>$business_email, 'address'=>$address,'status'=>$active_flag_html);
//         $srno++;
//         }
//         $record=array('success'=>true, 'msg'=>$msgDataFound, 'data'=>$feed_arr);
//         return jsonSendEncodeAdmin($record);

//     }
//   }


function getFeedData($data)
{
  error_reporting(0);
  global $mysqli;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $feed_id = decode($data['id']);
    $channel_arr = array();
    $check_data = $mysqli->prepare("SELECT `feed_id`, `user_id`, `description`,`createtime` FROM `feed_master`  WHERE  delete_flag='0'  and feed_id=?");
    $check_data->bind_param("i", $feed_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($feed_id, $user_id, $description, $createtime);
      $check_data->fetch();

      $feed_image_arr = getFeedImage($feed_id);



      //$user_id = encode($user_id);

      $userData = getUserDetails($user_id);
      $userName = $userData['name'];
      $userEmail = $userData['email'];
      $userimage = $userData['image'];

      $usermobile = $userData['mobile'];



      // $NoofLikes =getNoofLikes($feed_id);
      // $NoofComments =getNoofComments($feed_id);




      $feed_arr = array('srno' => $srno, 'feed_id' => $feed_id, 'userName' => $userName, 'userEmail' => $userEmail,  'createtime' => $createtime, 'description' => $description, 'feed_image_arr' => $feed_image_arr, 'userimage' => $userimage, 'usermobile' => $usermobile);
    }
    $record = array('success' => true, 'msg' => $msgDataFound, 'data' => $feed_arr);
    return jsonSendEncodeAdmin($record);
  }
}

function getFeedPostData($data)
{
  error_reporting(0);
  global $mysqli;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $post_id = decode($data['id']);
    $channel_arr = array();

    // print_r("SELECT `post_id`, `business_id`, `description`, `user_id`, `createtime` FROM `post_master` WHERE  delete_flag='0'  and post_id=?");
    $check_data = $mysqli->prepare("SELECT `post_id`, `business_id`, `description`, `user_id`, `createtime` FROM `post_master` WHERE  delete_flag='0'  and post_id=?");
    $check_data->bind_param("i", $post_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($post_id, $business_id, $description, $user_id, $createtime);
      $check_data->fetch();

      // $feed_image_arr =getFeedImage($post_id);



      //$user_id = encode($user_id);

      $userData = getUserDetails($user_id);
      $userName = $userData['name'];
      $userEmail = $userData['email'];
      $userimage = $userData['image'];

      $usermobile = $userData['mobile'];



      // $NoofLikes =getNoofLikes($feed_id);
      // $NoofComments =getNoofComments($feed_id);




      $feed_arr = array('srno' => $srno, 'feed_id' => $post_id, 'userName' => $userName, 'userEmail' => $userEmail,  'createtime' => $createtime, 'description' => $description, 'feed_image_arr' => $feed_image_arr, 'userimage' => $userimage, 'usermobile' => $usermobile, 'business_id' => $business_id);
    }
    $record = array('success' => true, 'msg' => $msgDataFound, 'data' => $feed_arr);
    return jsonSendEncodeAdmin($record);
  }
}



function checkAccountActivateDeactivate1($user_id)
{
  include('config.php');
  include_once('common_functions_app.php');

  $user_id = decode($user_id);

  $active_status    =   1;


  $check_active_all = $mysqli->prepare("SELECT active_flag FROM user_master WHERE user_id=? AND delete_flag = 0");
  $check_active_all->bind_param("i", $user_id);
  $check_active_all->execute();
  $check_active_all->store_result();
  $check_active = $check_active_all->num_rows;
  //echo $user_id;die;
  if ($check_active > 0) {
    $check_active_all->bind_result($active_flag_get);
    $check_active_all->fetch();

    if ($active_flag_get == 0) {
      $active_status = '0';
    }
  }

  return $active_status;
}

//function for get weblink start 

function getWeblinkData($data)
{
  // print_r($data);die;
  global $mysqli;
  include('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $user_id = decode($data['id']);
    // $commission_arr = array();
    $select_commission = $mysqli->prepare("SELECT `weblink_id`, `weblink_1`, `weblink_2`, `weblink_3` FROM `weblink_master` where delete_flag=0");
    $select_commission->execute();
    $select_commission->store_result();
    $select_commission_count = $select_commission->num_rows;
    if ($select_commission_count > 0) {
      $select_commission->bind_result($weblink_id, $weblink_1, $weblink_2, $weblink_3);
      $select_commission->fetch();
      $commission_arr = array('weblink_id' => $weblink_id, 'weblink_1' => $weblink_1, 'weblink_2' => $weblink_2, 'weblink_3' => $weblink_3);
    }
    if (empty($commission_arr)) {
      $commission_arr = 'NA';
    }
  }
  // print_r($content_arr);die;
  $record = array('success' => true, 'msg' => $msgDataFound, 'data' => $commission_arr);
  return jsonSendEncodeAdmin($record);
}

//function for get weblink end 




function getCategoryData111()
{

  global $mysqli;
  include_once('language_message.php');
  include_once('common_functions_app.php');


  //$user_id = decode($data['user_id']);

  $result = $mysqli->prepare("SELECT category_id,category_name FROM category_master where delete_flag=0 and type=1 ");
  $result->execute();
  $result->store_result();
  $row = $result->num_rows;
  if ($row <= 0) {
    $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $result->bind_result($category_id, $category_name);
    while ($result->fetch()) {
      $store_ary[]    =   array(
        'user_id'    =>  $category_id,
        'name'       =>  $category_name,


      );
    }
  }
  if (empty($store_ary)) {
    $store_ary = array();
  }
  $record = array('success' => true, 'data' => array('store_ary' => $store_ary));
  return jsonSendEncodeAdmin($record);
}

function getBuisnessCategoryData()
{

  global $mysqli;
  include_once('language_message.php');
  include_once('common_functions_app.php');


  //$user_id = decode($data['user_id']);


  $result = $mysqli->prepare("SELECT business_id,business_name FROM business_master where delete_flag=0 ");
  $result->execute();
  $result->store_result();
  $row = $result->num_rows;
  if ($row <= 0) {
    $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $result->bind_result($business_id, $business_name);
    while ($result->fetch()) {
      $store_ary1[]    =   array(
        'user_id1'    =>  $business_id,
        'name1'       =>  $business_name,


      );
    }
  }
  if (empty($store_ary1)) {
    $store_ary1 = array();
  }
  $record = array('success' => true, 'data' => array('store_ary' => $store_ary1));
  return jsonSendEncodeAdmin($record);
}

function getDataOFEbooks() {

        global $mysqli;
        include_once('language_message.php');
        include_once('common_functions_app.php');

   
         //$user_id = decode($data['user_id']);
            
        $result = $mysqli->prepare("SELECT `ebook_id`, `title` FROM `ebook_master` where delete_flag=0  order by ebook_id ASC ");
        $result->execute();
        $result->store_result();
        $row = $result->num_rows;
        if($row <= 0){
            $record=array('success'=>false,'msg'=>$msgInvalidId,'data'=>array()); 
            return jsonSendEncodeAdmin($record); 
        }
        else{
            $result->bind_result($ebook_id,$title);
            while($result->fetch()) {
                $store_ary[]    =   array(
                    'ebook_id'    =>  $ebook_id,
                    'title'       =>  $title,
                   
                   
                );
            }
        }
        if(empty($store_ary)){
            $store_ary= array();
        }
        $record=array('success'=>true,'data'=>array('store_ary'=>$store_ary)); 
        return jsonSendEncodeAdmin($record);  
    

} 
function getServiceData($data)
{
  error_reporting(0);
  global $mysqli;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $service_id = decode($data['id']);
    $channel_arr = array();
    $check_data = $mysqli->prepare("SELECT `service_id`, `service_category_id`, `service_name`, `service_description`, `service_location`,`website_url`, `service_image`, `service_email`, `service_phone_number`,  `createtime` FROM `service_master`WHERE  delete_flag='0'  and service_id=?");
    $check_data->bind_param("i", $service_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($service_id, $service_category_id, $service_name, $service_description, $service_location, $website_url, $service_image, $service_email, $service_phone_number, $createtime);
      $check_data->fetch();

      $createtime = date('d-m-Y h:i A', strtotime($createtime));


      $serviceCatName = getCategoryName($service_category_id);

      $image_html = '<img  width="50px" src="../webservice/images/' . $service_image . '" class="rounded-circle circle-border m-b-md img-fix img-responsive" name="profile_image" id="previewholder" style="width: 70px; height: 70px;" alt="" onerror="this.src=' . $onerror . ';" >';






      $action_html = '

        <div class="btn-group">

                                                    <button type="button" class="btn btn-primary btn-outline dropdown-toggle float-button-light" id="primary-dropdown-outline" data-bs-toggle="dropdown" aria-expanded="false">

                                                        Action

                                                    </button>

                                                    <ul class="dropdown-menu dropdown-menu-primary" style=" margin: 2px -56px 0;" aria-labelledby="primary-dropdown" role="menu">

                                                        <li><a href="view_service.php?id=' . encode($service_id) . '"" class="dropdown-item"><i class="fas fa-eye"></i>View</a></li>

                          
                                                   <a class="dropdown-item" href="edit_service.php?id=' . encode($service_id) . '" ><i class="fa fa-edit"></i>&nbsp;Edit</a>
                          



                                                 <a class="dropdown-item"  href="javascript:void(0)" data-id="' . $service_id . '"  onClick="btnDeleteConfirm(this)"><i class="fa fa-trash" "></i>&nbsp;Delete</a>

                            



                                                        

                                                    </ul>

                                                </div>




      
';
      $service_arr = array('srno' => $srno, 'service_id' => $service_id, 'serviceCatName' => $serviceCatName, 'service_description' => $service_description, 'service_location' => $service_location, 'service_email' => $service_email, 'action' => $action_html, 'createtime' => $createtime, 'service_phone_number' => $service_phone_number, 'image' => $service_image, 'service_name' => $service_name, 'service_category_id' => $service_category_id, 'website_url' => $website_url);
    }
    $record = array('success' => true, 'msg' => $msgDataFound, 'data' => $service_arr);
    return jsonSendEncodeAdmin($record);
  }
}

function getEditEbookEventsData($data)
{
  // error_reporting(0);
  global $mysqli;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $event_id = decode($data['id']);
    $event_arr = array();
    $check_data = $mysqli->prepare("SELECT `description`, `title`, `image`, `createtime`, `updatetime`,recommend_status FROM `event_master`  WHERE  delete_flag='0'  and event_id=?");
    $check_data->bind_param("i", $event_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;

    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($description, $title, $image, $createtime, $updatetime, $recommend_status);
      $check_data->fetch();

      $createtime = date('d-m-Y h:i A', strtotime($createtime));
      $updatetime = date('d-m-Y h:i A', strtotime($updatetime));

      $service_arr = array('description' => $description, 'title' => $title, 'image' => $image, 'createtime' => $createtime, 'updatetime' => $updatetime, 'recommend_status' => $recommend_status);
    }

    // print_r($service_arr);die;
    $record = array('success' => true, 'msg' => '', 'data' => $service_arr);
    return jsonSendEncodeAdmin($record);
  }
}

function getupdateSubscriptionData($data)
{
  // error_reporting(0);
  global $mysqli;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    // $event_id = decode($data['id']);
    $event_arr = array();
    $check_data = $mysqli->prepare("SELECT `plan_id`, `plan_type`, `plan_name`, `plan_amount`, `no_of_days`, `plan_period`, `createtime`, `updatetime` FROM `plan_master`  WHERE  delete_flag='0'");
    // $check_data->bind_param("i", $event_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;

    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($plan_id, $plan_type, $plan_name, $plan_amount, $no_of_days, $plan_period, $createtime, $updatetime);
      $check_data->fetch();

      $createtime = date('d-m-Y h:i A', strtotime($createtime));
      $updatetime = date('d-m-Y h:i A', strtotime($updatetime));

      $service_arr = array('plan_id' => $plan_id, 'plan_type' => $plan_type, 'plan_name' => $plan_name, 'plan_amount' => $plan_amount, 'no_of_days' => $no_of_days, 'plan_period' => $plan_period, 'createtime' => $createtime, 'updatetime' => $updatetime);
    }

    // print_r($service_arr);die;
    $record = array('success' => true, 'msg' => '', 'data' => $service_arr);
    return jsonSendEncodeAdmin($record);
  }
}


function getEditBusinessData($data)
{
  // error_reporting(0);
  global $mysqli;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $business_id = decode($data['id']);
    $event_arr = array();
    // $selectname=$data['selectname'];
    // echo "SELECT `event_id`, `category_id`, `event_date_time`, `address`, `latitude`, `longitude`, `event_ticket_price`, `total_tickets`, `title`, `description`, `createtime` FROM `event_master`WHERE  delete_flag='0'  and event_id=";
    $check_data = $mysqli->prepare("SELECT `business_id`, `user_id`, `business_name`, `business_phone`, `business_email`, `description`, `address`, `latitude`, `longitude`, `approve_flag`, `active_flag`, `createtime`, `updatetime`, `category_id`, `profile_image` FROM `business_master` WHERE  delete_flag='0'  and business_id=?");
    $check_data->bind_param("i", $business_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;

    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($business_id, $user_id, $business_name, $business_phone, $business_email, $description, $address, $latitude, $longitude, $approve_flag, $active_flag, $createtime, $updatetime, $category_id, $image);
      $check_data->fetch();

      $createtime = date('d-m-Y h:i A', strtotime($createtime));

      $image_html = '<img  width="50px" src="../webservice/images/' . $image . '" class="rounded-circle circle-border m-b-md img-fix img-responsive" name="profile_image" id="previewholder" style="width: 70px; height: 70px;" alt="" onerror="this.src=' . $onerror . ';" >';



      $action_html = '

        <div class="btn-group">

                                                    <button type="button" class="btn btn-primary btn-outline dropdown-toggle float-button-light" id="primary-dropdown-outline" data-bs-toggle="dropdown" aria-expanded="false">

                                                        Action

                                                    </button>

                                                    <ul class="dropdown-menu dropdown-menu-primary" style=" margin: 2px -56px 0;" aria-labelledby="primary-dropdown" role="menu">
                          
                                                   <a class="dropdown-item" href="edit_business.php?id=' . encode($business_id) . '" ><i class="fa fa-edit"></i>&nbsp;Edit</a>

                                                    </ul>

                                                </div>   
';
      $service_arr = array('srno' => $srno, 'business_id' => $business_id, 'user_id' => $user_id, 'business_name' => $business_name, 'business_phone' => $business_phone, 'business_email' => $business_email, 'description' => $description, 'address' => $address, 'latitude' => $latitude, 'longitude' => $longitude, 'approve_flag' => $approve_flag, 'active_flag' => $active_flag, 'createtime' => $createtime, 'updatetime' => $updatetime, 'category_id' => $category_id, 'image' => $image, 'action' => $action_html);
    }

    // print_r($service_arr);die;
    $record = array('success' => true, 'msg' => $msgDataFound, 'data' => $service_arr);
    return jsonSendEncodeAdmin($record);
  }
}

function getEbookData($data)
{
  global $mysqli;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $ebook_id = decode($data['id']);
    $check_data = $mysqli->prepare("SELECT `title`, `descriptions`, `image`, `price`, `pdf_url`, `createtime`,recommend_status FROM `ebook_master` WHERE  delete_flag='0'  and ebook_id=?");
    $check_data->bind_param("i", $ebook_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;

    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($title, $descriptions, $image, $price, $pdf_url, $createtime,$recommend_status);
      $check_data->fetch();

      $createtime = date('d-m-Y h:i A', strtotime($createtime));

      $service_arr = array('title' => $title, 'descriptions' => $descriptions, 'image' => $image, 'price' => $price, 'pdf_url' => $pdf_url, 'createtime' => $createtime, 'recommend_status' => $recommend_status);
    }

    // print_r($service_arr);die;
    // $record = array('success' => true, 'msg' => $msgDataFound, 'data' => $service_arr);
    // return jsonSendEncodeAdmin($record);
        $record = array('success' => true, 'msg' => '', 'data' => $service_arr);
    return jsonSendEncodeAdmin($record);
  }
}

function getEducationData($data)
{
  global $mysqli;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' =>'', 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $education_id = decode($data['id']);
    $check_data = $mysqli->prepare("SELECT `education_id`, `name`, `createtime` FROM `education_master` WHERE  delete_flag='0'  and education_id=?");
    $check_data->bind_param("i", $education_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;

    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($education_id, $name, $createtime);
      $check_data->fetch();

      $createtime = date('d-m-Y h:i A', strtotime($createtime));

      $service_arr = array('education_id' => $education_id, 'name' => $name, 'createtime' => $createtime);
    }

    // print_r($service_arr);die;
    // $record = array('success' => true, 'msg' => $msgDataFound, 'data' => $service_arr);
    // return jsonSendEncodeAdmin($record);
        $record = array('success' => true, 'msg' => '', 'data' => $service_arr);
    return jsonSendEncodeAdmin($record);
  }
}

function getProfessionData12()
{
  global $mysqli;
  include_once('language_message.php');
  
   
    $check_data = $mysqli->prepare("SELECT `profession_id`, `name`, `createtime` FROM `profession_master` WHERE  delete_flag='0' ");
    //$check_data->bind_param("i", $education_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;

    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($profession_id, $name, $createtime);
      while($check_data->fetch()){
         $createtime = date('d-m-Y h:i A', strtotime($createtime));
$service_arr[] = array('profession_id' => $profession_id, 'name' => $name);
      }

     

      
    }

    // print_r($service_arr);die;
    // $record = array('success' => true, 'msg' => $msgDataFound, 'data' => $service_arr);
    // return jsonSendEncodeAdmin($record);
        $record = array('success' => true, 'msg' => '', 'data' => $service_arr);
    return jsonSendEncodeAdmin($record);
  
}
function getCountryData12()
{
  global $mysqli;
  include_once('language_message.php');
  
   
    $check_data = $mysqli->prepare("SELECT `country_id`, `country_name`, `createtime` FROM `country_master` WHERE  delete_flag='0' ");
    //$check_data->bind_param("i", $education_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;

    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($country_id, $name, $createtime);
      while($check_data->fetch()){
         $createtime = date('d-m-Y h:i A', strtotime($createtime));
$service_arr[] = array('country_id' => $country_id, 'name' => $name);
      }

     

      
    }

    // print_r($service_arr);die;
    // $record = array('success' => true, 'msg' => $msgDataFound, 'data' => $service_arr);
    // return jsonSendEncodeAdmin($record);
        $record = array('success' => true, 'msg' => '', 'data' => $service_arr);
    return jsonSendEncodeAdmin($record);
  
}
function getEducationData12()
{
  global $mysqli;
  include_once('language_message.php');
  
   
    $check_data = $mysqli->prepare("SELECT `education_id`, `name`, `createtime` FROM `education_master` WHERE  delete_flag='0' ");
    //$check_data->bind_param("i", $education_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;

    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($education_id, $name, $createtime);
      while($check_data->fetch()){
         $createtime = date('d-m-Y h:i A', strtotime($createtime));
$service_arr[] = array('education_id' => $education_id, 'name' => $name);
      }

     

      
    }

    // print_r($service_arr);die;
    // $record = array('success' => true, 'msg' => $msgDataFound, 'data' => $service_arr);
    // return jsonSendEncodeAdmin($record);
        $record = array('success' => true, 'msg' => '', 'data' => $service_arr);
    return jsonSendEncodeAdmin($record);
  
}



function getEbookTrainingData($data)
{
  global $mysqli;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $ebook_training_id = decode($data['id']);
    $check_data = $mysqli->prepare("SELECT `ebook_id`, `training_type`, `description`, `image`, `createtime`, `recommend_status`, `exercise_training_type`, `max_no_of_player`, `min_no_of_player`, `selller_type`, `tactical`, `informational`, `conditional`, `exercise_image`, `focus`, `matchfield`, `exercise_type`,title ,rules FROM `ebook_training_master` WHERE  delete_flag='0'  and ebook_training_id=?");
    $check_data->bind_param("i", $ebook_training_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;

    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($ebook_id, $training_type, $description, $image, $createtime,$recommend_status, $exercise_training_type, $max_no_of_player, $min_no_of_player, $selller_type,$tactical, $informational, $conditional, $exercise_image, $focus, $matchfield, $exercise_type,$title,$rules);
      $check_data->fetch();

      // $get_ebook_name = get_ebook_name($ebook_id);
      $createtime = date('d-m-Y h:i A', strtotime($createtime));
      // if ($training_type==0) {
      // $training='Other';
      // }else{
      // $training='Ebook';
      // }
      $service_arr = array('ebook_id' => $ebook_id, 'training_type' => $training_type, 'description' => $description, 'image' => $image, 'createtime' => $createtime, 'recommend_status' => $recommend_status, 'exercise_training_type' => $exercise_training_type, 'max_no_of_player' => $max_no_of_player, 'min_no_of_player' => $min_no_of_player, 'selller_type' => $selller_type, 'tactical' => $tactical, 'informational' => $informational, 'conditional' => $conditional, 'exercise_image' => $exercise_image, 'focus' => $focus, 'matchfield' => $matchfield, 'exercise_type' => $exercise_type, 'title' => $title, 'rules' => $rules);
    }

    // print_r($service_arr);die;
    // $record = array('success' => true, 'msg' => $msgDataFound, 'data' => $service_arr);
    // return jsonSendEncodeAdmin($record);
        $record = array('success' => true, 'msg' => '', 'data' => $service_arr);
    return jsonSendEncodeAdmin($record);
  }
}

function getEbookvideoData($data)
{
  global $mysqli;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $ebook_video_id = decode($data['id']);
    $check_data = $mysqli->prepare("SELECT `ebook_video_id`, `ebook_id`, `video_type`, `video_url`, `title`, `image`, `createtime`, `updatetime` FROM `ebook_video_master` WHERE  delete_flag='0'  and ebook_video_id=?");
    $check_data->bind_param("i", $ebook_video_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;

    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($ebook_video_id, $ebook_id, $video_type, $video_url, $title, $image, $createtime, $updatetime);
      $check_data->fetch();

      // $get_ebook_name = get_ebook_name($ebook_id);
      $createtime = date('d-m-Y h:i A', strtotime($createtime));
      // if ($training_type==0) {
      // $training='Other';
      // }else{
      // $training='Ebook';
      // }
      $service_arr = array('ebook_video_id' => $ebook_video_id, 'ebook_id' => $ebook_id, 'video_type' => $video_type, 'video_url' => $video_url, 'title' => $title, 'image' => $image, 'createtime' => $createtime, 'updatetime' => $updatetime);
    }

    // print_r($service_arr);die;
    // $record = array('success' => true, 'msg' => $msgDataFound, 'data' => $service_arr);
    // return jsonSendEncodeAdmin($record);
        $record = array('success' => true, 'msg' => '', 'data' => $service_arr);
    return jsonSendEncodeAdmin($record);
  }
}





function getViewbuisnessData($data)
{
  //error_reporting(0);
  global $mysqli;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $business_id = decode($data['id']);
    $user_arr = array();
    // echo('SELECT `user_id`, `business_name`, `business_phone`, `business_email`, `description`, `address`, `latitude`, `longitude`, `status`, `createtime`, `category_id` FROM business_master WHERE business_id=1');exit();
    $check_data = $mysqli->prepare("SELECT  `user_id`, `business_name`, `business_phone`, `business_email`, `description`, `address`, `latitude`, `longitude`, `approve_flag`, `delete_flag`, `createtime`, `category_id`, `profile_image` FROM `business_master` WHERE business_id=?");
    $check_data->bind_param("i", $business_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($user_id, $business_name, $business_phone, $business_email, $description, $address, $latitude, $longitude, $status, $delete_flag, $createtime, $category_id, $profile_image);
      // $check_data->bind_result($user_id,$bio,$innocence_project_id,$lead_attorney,$acknowledge_box,$mobile,$email,$name,$image,$active_flag,$createtime);
      $check_data->fetch();

      $createtime = date('d-m-Y h:i A', strtotime($createtime));
      $eventCatName = getCategoryNameForBusiness($category_id);
      // print_r($eventCatName);die;
      $category_name = $eventCatName['category_name'];
      // $image=$eventCatName['image'];

      // print_r($image);die;

      $userData = getUserDetails($user_id);
      $username = $userData['name'];
      // $usermobile=$userData['mobile'];
      // $innocence_project_name =getInnocenceName($innocence_project_id);


      if ($status == '1') {
        $status_text = '0';
        $status_html = '<label class="btn btn-success btn-sm"> Approve</label>';
      } else {
        $status_text = '1';
        $status_html = '<label class="btn btn-danger btn-sm"> Unapprrove</label>';
      }





      $user_arr = array('business_name' => $business_name, 'business_phone' => $business_phone, 'business_email' => $business_email, 'description' => $description, 'address' => $address, 'latitude' => $latitude, 'longitude' => $longitude, 'status' => $status, 'createtime' => $createtime, 'image' => $image, 'business_id' => $business_id, 'status_flag' => $status_html, 'category' => $category_name, 'username' => $username, 'profile_image' => $profile_image);
    }
    $record = array('success' => true, 'msg' => $msgDataFound, 'data' => $user_arr);
    return jsonSendEncodeAdmin($record);
  }
}

function getViewEventsData($data)
{
  //error_reporting(0);
  global $mysqli;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $event_id = decode($data['id']);
    $user_arr = array();
    // echo('SELECT `user_id`, `business_name`, `business_phone`, `business_email`, `description`, `address`, `latitude`, `longitude`, `status`, `createtime`, `category_id` FROM business_master WHERE business_id=1');exit();
    $check_data = $mysqli->prepare("SELECT `event_id`, `description`, `title`, `image`, `createtime`, `updatetime` FROM `event_master`  WHERE event_id=?");
    $check_data->bind_param("i", $event_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($event_id, $description, $title, $image, $createtime, $updatetime);
      $check_data->fetch();
      $createtime = date('d-m-Y h:i A', strtotime($createtime));
      $updatetime = date('d-m-Y h:i A', strtotime($updatetime));

      $user_arr = array('event_id' => $event_id, 'description' => $description, 'title' => $title, 'image' => $image, 'createtime' => $createtime, 'updatetime' => $updatetime);
    }
    $record = array('success' => true, 'msg' => '', 'data' => $user_arr);
    return jsonSendEncodeAdmin($record);
  }
}

function getViewVideoData($data)
{
  //error_reporting(0);
  global $mysqli;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $ebook_video_id = decode($data['id']);
    $user_arr = array();
    // echo('SELECT `user_id`, `business_name`, `business_phone`, `business_email`, `description`, `address`, `latitude`, `longitude`, `status`, `createtime`, `category_id` FROM business_master WHERE business_id=1');exit();
    $check_data = $mysqli->prepare("SELECT `ebook_video_id`, `ebook_id`, `video_type`, `video_url`, `title`, `image`, `createtime`, `updatetime` FROM `ebook_video_master`  WHERE ebook_video_id=?");
    $check_data->bind_param("i", $ebook_video_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($ebook_video_id, $ebook_id, $video_type, $video_url, $title, $image, $createtime, $updatetime);
      $check_data->fetch();
      $get_ebook_name = get_ebook_name($ebook_id);
      $createtime = date('d-m-Y h:i A', strtotime($createtime));
      $updatetime = date('d-m-Y h:i A', strtotime($updatetime));
if ($video_type==0) {
    $video_type_get='Other';
}else{
    $video_type_get='Ebook';
}
            $status = "'video'";
            $video_html = '<div href="#video_view" style="text-align: center;">
                      <a href="#video_view">
  
  
                              <video  class=" circle-border m-b-md img-fix img-responsive" name="profile_image" id="previewholder" style="width: 250px; height: auto;" "alt=""  onclick="view_img(this,' . $status . ')" poster="../webservice/images/' . $image . '" controls>
                                <source src="../webservice/videos/' . $video_url . '" type="video/mp4">
                                
                              </video>

';

                         //                              <div class="open_my_popup" id="video_view">
                         //    <div class="imgae_view_bg"></div>
                         //    <div class="view_popup"> <img src="" id="image_here" class="image_here" /> </div>
                         //     <a class="close_my_popup" onclick="closePopup();"><img src="assets/images/close.png" /></a></div>
                         //     </a>

                         // </div>
      $user_arr = array('ebook_video_id' => $ebook_video_id, 'ebook_id' => $get_ebook_name, 'video_type' => $video_type_get, 'video_url' => $video_html, 'title' => $title, 'image' => $image, 'createtime' => $createtime, 'updatetime' => $updatetime);
    }
    $record = array('success' => true, 'msg' => '', 'data' => $user_arr);
    return jsonSendEncodeAdmin($record);
  }
}

function getViewTicketsData($data)
{
  //error_reporting(0);
  global $mysqli;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $booking_id = decode($data['id']);
    $user_arr = array();
    // echo('SELECT `user_id`, `business_name`, `business_phone`, `business_email`, `description`, `address`, `latitude`, `longitude`, `status`, `createtime`, `category_id` FROM business_master WHERE business_id=1');exit();
    $check_data = $mysqli->prepare("SELECT `event_id`, `ticket_nos`, `number_of_kids`, `number_of_adults`, `transaction_id`, `payment_status`, `user_id`, `booking_status`, `ticket_code`, `qr_image`, `booking_number`, `address`, `delete_flag`, `active_flag`, `createtime` FROM `booking_master` WHERE booking_id=?");
    $check_data->bind_param("i", $booking_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($event_id, $ticket_nos, $number_of_kids, $number_of_adults, $transaction_id, $payment_status, $user_id, $booking_status, $ticket_code, $qr_image, $booking_number, $address, $delete_flag, $active_flag, $createtime);
      // $check_data->bind_result($user_id,$bio,$innocence_project_id,$lead_attorney,$acknowledge_box,$mobile,$email,$name,$image,$active_flag,$createtime);
      $check_data->fetch();

      $createtime = date('d-m-Y h:i A', strtotime($createtime));

      $eventcategory = getCategoryNameForEvents($event_id);
      if ($eventcategory != "NA") {
        $category_name = $eventcategory['category_name'];
      }

      $event_name = getEventNameforview($event_id);

      $event_address = getEventAddressforview($event_id);



      $username = getUserDetails($user_id);
      $customer_name = $username['name'];
      // $eventCatName = getCategoryNameForEvents($category_id);
      // $userimage=$eventCatName['image'];
      // $eventCatName = getCategoryNameForEvents($category_id);
      // $innocence_project_name =getInnocenceName($innocence_project_id);


      if ($booking_status == '1') {
        $booking_status_text = '1';
        $booking_status_html = '<label class="btn btn-success btn-sm">Confirmed</label>';
      } else {
        $booking_status_text = '2';
        $booking_status_html = '<label class="btn btn-danger btn-sm">Not-Confirmed</label>';
      }




      $user_arr = array('ticket_nos' => $ticket_nos, 'number_of_kids' => $number_of_kids, 'number_of_adults' => $number_of_adults, 'transaction_id' => $transaction_id, 'payment_status' => $payment_status, 'user_id' => $customer_name, 'booking_status' => $booking_status_html, 'ticket_code' => '#' . $ticket_code, 'event_id' => $event_name, 'booking_number' => $booking_number, 'active_flag' => $active_flag, 'image' => $qr_image, 'createtime' => $createtime, 'address' => $event_address);
    }
    $record = array('success' => true, 'msg' => $msgDataFound, 'data' => $user_arr);
    return jsonSendEncodeAdmin($record);
  }
}


function getupdateVideocallData($data)
{
  // error_reporting(0);
  global $mysqli;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    // $event_id = decode($data['id']);
    $event_arr = array();
    $check_data = $mysqli->prepare("SELECT `like_count_id`, `likes`, `superlike` FROM `set_like_count_master`  WHERE  delete_flag='0'");
    // $check_data->bind_param("i", $event_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;

    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($like_count_id, $likes,$superlike);
      $check_data->fetch();
      $service_arr= array('like_count_id' => $like_count_id, 'likes' => $likes,'superlike'=>$superlike);  
      

     

      
    }

    // print_r($service_arr);die;
    $record = array('success' => true, 'msg' => '', 'data' => $service_arr);
    return jsonSendEncodeAdmin($record);
  }
}


function getViewPriceData()
{

  global $mysqli;
  include_once('language_message.php');
  include_once('common_functions_app.php');


  //$user_id = decode($data['user_id']);

  $result = $mysqli->prepare("SELECT video_call_price_id, price_name, price FROM video_call_price_master where delete_flag=0 ");
  $result->execute();
  $result->store_result();
  $row = $result->num_rows;
  if ($row <= 0) {
    $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $result->bind_result($video_call_price_id, $price_name,$price);
    while ($result->fetch()) {
      $store_ary[]    =   array(
        'video_call_price_id'    =>  $video_call_price_id,
        'price_name'       =>  $price_name,
        'price'=>$price,


      );
    }
  }
  if (empty($store_ary)) {
    $store_ary = array();
  }
  $record = array('success' => true, 'data' => array('store_ary' => $store_ary));
  return jsonSendEncodeAdmin($record);
}


function getViewTripData($data)
{
  //error_reporting(0);
  global $mysqli;
  global $onerror;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $trip_id = decode($data['id']);
    $user_arr = array();
    
    $check_data = $mysqli->prepare("SELECT `trip_id`, `user_id`, `title`, `trip_start_date`, `description`, `status`, `createtime`  FROM `trip_master` WHERE   trip_id=?");
    $check_data->bind_param("i", $trip_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' =>'', 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($trip_id, $user_id, $title, $trip_start_date, $description, $status, $createtime);
     
      $check_data->fetch();

      $noofviews =getTotalViews($trip_id);
      $noofwatching =getTotalWatching($trip_id);

      $createtime = date('d-m-Y h:i A', strtotime($createtime));
      $trip_start_date = date('d-m-Y ', strtotime($trip_start_date));
      
      // $innocence_project_name = getInnocenceName($innocence_project_id);
      $userData =getUserDetails($user_id);
      if($userData != 'NA'){
       $fName =$userData['f_name'];
      $lName =$userData['l_name'];
      $Email =$userData['email'];
      $image =$userData['image'];
      $mobile =$userData['mobile'];
      $image_html = '<img  width="50px" src="../webservice/images/' . $image . '" class="rounded-circle circle-border m-b-md img-fix img-responsive" name="profile_image" id="previewholder" style="width: 70px; height: 70px;" alt="" onerror="this.src=' . $onerror . ';" >';
        
      }else{
      $fName ='NA';
      $lName ='NA';
      $Email ='NA';
      $image ='NA';
      $mobile ='NA';
      $image_html = 'NA';
        
      }

       if($status == 0){
        $status_text ='<label class="badge badge-success">Current</label>';
      }else if($status == 1){
         $status_text ='<label class="badge badge-info">Upcoming</label>';
      }else{
           $status_text ='<label class="badge badge-danger">History</label>';
      }
      
     

     

      


     

      

     




      $user_arr = array('f_name' => $fName,'l_name' => $lName, 'email' => $Email, 'mobile' =>'+1 '.$mobile, 'image' => $image_html, 'createtime' => $createtime,'title'=>$title,'description'=>$description,'trip_start_date'=>$trip_start_date,'status'=>$status_text,'noofwatching'=>$noofwatching,'noofviews'=>$noofviews);
    }
    $record = array('success' => true, 'msg' => '', 'data' => $user_arr);
    return jsonSendEncodeAdmin($record);
  }
}


function getViewTripVideoData($data)
{
  //error_reporting(0);
  global $mysqli;
  global $onerror;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $trip_id = decode($data['id']);
    $user_arr = array();
    
    $check_data = $mysqli->prepare("SELECT  `trip_video_id`, `location`, `video`, `streaming_video_status`, `type`, `video_date`, `video_time`, `createtime`  FROM `trip_video_master` WHERE   trip_video_id=?");
    $check_data->bind_param("i", $trip_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' =>'', 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result( $trip_video_id, $location, $video, $streaming_video_status, $type, $video_date, $video_time, $createtime);
     
      $check_data->fetch();

      
      $video_html ='

      <video width="220" height="240" controls>
  <source src="../webservice/videos/' . $video . '" type="video/mp4">
 
</video>


      ';
             
      $createtime = date('d-m-Y h:i A', strtotime($createtime));
      $video_date = date('d-m-Y ', strtotime($video_date));
      $video_time = date('H:i ', strtotime($video_time));
      
      // $innocence_project_name = getInnocenceName($innocence_project_id);
      

       if($type == 0){
                $type_text ='<label class="badge badge-success">Streaming</label>';
              }else{
                $type_text ='<label class="badge badge-info">Video</label>';
              }

              if($streaming_video_status == 0){
                $streaming_video_status_text ='<label class="badge badge-success">No</label>';
              }else{
                $streaming_video_status_text ='<label class="badge badge-info">Yes</label>';
              }
      
     

     

      


     

      

     




      $user_arr =  array( 'trip_video_id' => $trip_video_id, 'type_text' => $type_text, 'video_date' => $video_date, 'video' => $video_html, 'createtime' => $createtime, 'video_time' => $video_time,'streaming_video_status_text'=>$streaming_video_status_text,'location'=>$location);
    }
    $record = array('success' => true, 'msg' => '', 'data' => $user_arr);
    return jsonSendEncodeAdmin($record);
  }
}


function getViewProposedTripData($data)
{
  //error_reporting(0);
  global $mysqli;
  global $onerror;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $trip_id = decode($data['id']);
    $user_arr = array();
    
    $check_data = $mysqli->prepare("SELECT `proposed_trip_id`, `user_id`,`other_user_id`, `title`, `trip_date`, `type`, `description`, `additional_note`, `createtime`,`status`  FROM `proposed_trip_master` WHERE   proposed_trip_id=?");
    $check_data->bind_param("i", $trip_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' =>'', 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($proposed_trip_id, $user_id,$other_user_id, $title, $trip_start_date,  $type,$description,$additional_note, $createtime,$status);
     
      $check_data->fetch();

      

      $createtime = date('d-m-Y h:i A', strtotime($createtime));
      $trip_start_date = date('d-m-Y ', strtotime($trip_start_date));
      
      // $innocence_project_name = getInnocenceName($innocence_project_id);
      $userData =getUserDetails($user_id);
      if($userData != 'NA'){
       $fName =$userData['f_name'];
      $lName =$userData['l_name'];
      $Email =$userData['email'];
      $image =$userData['image'];
      $mobile =$userData['mobile'];
      $image_html = '<img  width="50px" src="../webservice/images/' . $image . '" class="rounded-circle circle-border m-b-md img-fix img-responsive" name="profile_image" id="previewholder" style="width: 70px; height: 70px;" alt="" onerror="this.src=' . $onerror . ';" >';
        
      }else{
      $fName ='NA';
      $lName ='NA';
      $Email ='NA';
      $image ='NA';
      $mobile ='NA';
      $image_html = 'NA';
        
      }

      $userData1 =getUserDetails($other_user_id);
      if($userData1 != 'NA'){
       $fName1 =$userData1['f_name'];
      $lName1 =$userData1['l_name'];
      $Email1 =$userData1['email'];
      $image1 =$userData1['image'];
      $mobile1 =$userData1['mobile'];
      $image_html1 = '<img  width="50px" src="../webservice/images/' . $image1 . '" class="rounded-circle circle-border m-b-md img-fix img-responsive" name="profile_image" id="previewholder" style="width: 70px; height: 70px;" alt="" onerror="this.src=' . $onerror . ';" >';
        
      }else{
      $fName1 ='NA';
      $lName1 ='NA';
      $Email1 ='NA';
      $image1 ='NA';
      $mobile1 ='NA';
      $image_html1 = 'NA';
        
      }

       if($type == 0){
        $type_text ='<label class="badge badge-success">Everyone</label>';
      }else{
           $type_text ='<label class="badge badge-danger">Tracker</label>';
      }

      if($status == 0){
        $status_text ='<label class="badge badge-warning">Pending</label>';
      }else{
           $status_text ='<label class="badge badge-success">Accepted</label>';
      }
      
     

     

      


     

      

     




      $user_arr = array('f_name' => $fName,'l_name' => $lName, 'email' => $Email, 'mobile' =>'+1 '.$mobile, 'image' => $image_html, 'createtime' => $createtime,'title'=>$title,'description'=>$description,'trip_start_date'=>$trip_start_date,'status'=>$status_text,'additional_note'=>$additional_note,'f_name1' => $fName1,'l_name1' => $lName1, 'email1' => $Email1, 'mobile1' =>'+1 '.$mobile1, 'image1' => $image_html1,'type'=>$type_text);
    }
    $record = array('success' => true, 'msg' => '', 'data' => $user_arr);
    return jsonSendEncodeAdmin($record);
  }
}


function getViewUsersEventData($data)
{
  //error_reporting(0);
  global $mysqli;
  global $onerror;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $event_id = decode($data['id']);
    $user_arr = array();
    
    $check_data = $mysqli->prepare("SELECT `post_id`, `user_id`, `event_type`, `title`, `description`, `date`, `time`, `link`,  `createtime` FROM `post_master` WHERE   post_id=? and type = 0 and delete_flag =0");
    $check_data->bind_param("i", $event_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($event_id,$user_id,$event_type, $event_title,$quick_description,$date,$time,$event_link, $createtime);
    
      $check_data->fetch();

       $date = date('d-m-Y ', strtotime($date));
        $time = date('h:i A', strtotime($time));
$EventImages =getEventImages($event_id);
     
      
          
      if($event_type == 0){
        $event_text ='<label class="badge badge-success">Virtual</label>';
      }else if($event_type == 1){
         $event_text ='<label class="badge badge-info">Physical</label>';
      }else{
           $event_text ='<label class="badge badge-primary">Hybrid</label>';
      }
      
      

      
   
    


      

      

      $createtime = date('d-m-Y h:i A', strtotime($createtime));
    
     

     
     

     

      


       

      

     





      $user_arr = array('event_id' => $event_id, 'event_title' => $event_title, 'date'=>$date, 'createtime' => $createtime,'event_type'=>$event_text,'time'=>$time,'quick_description'=>$quick_description,'event_link'=>$event_link,'EventImages'=>$EventImages);
    }
    $record = array('success' => true, 'msg' => '', 'data' => $user_arr);
    return jsonSendEncodeAdmin($record);
  }
}

function getViewUsersNewsUpdateData($data)
{
  //error_reporting(0);
  global $mysqli;
  global $onerror;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $event_id = decode($data['id']);
    $user_arr = array();
    
    $check_data = $mysqli->prepare("SELECT `post_id`, `user_id`,  `title`, `description`,  `link`,`tags`,  `createtime` FROM `post_master` WHERE   post_id=? and type = 4 and delete_flag =0");
    $check_data->bind_param("i", $event_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($news_id,$user_id,$title,$description,$link,$tags, $createtime);
    
      $check_data->fetch();

      
$NewsUpdatesImages =getNewsUpdatesImages($news_id);
$NewsUpdatesVideos =getNewsUpdatesVideos($news_id);
$NewsUpdatespdf =getNewsUpdatesPdf($news_id);
     
      
          
     
      
      

      
   
    


      

      

      $createtime = date('d-m-Y h:i A', strtotime($createtime));
    
     

     
     

     

      


       

      

     





      $user_arr = array('news_id' => $news_id, 'title' => $title,  'createtime' => $createtime,'description'=>$description,'link'=>$link,'NewsUpdatesImages'=>$NewsUpdatesImages,'tags'=>$tags,'NewsUpdatesVideos'=>$NewsUpdatesVideos,'NewsUpdatespdf'=>$NewsUpdatespdf);
    }
    $record = array('success' => true, 'msg' => '', 'data' => $user_arr);
    return jsonSendEncodeAdmin($record);
  }
}


function getViewUsersKnowledgeSnippetData($data)
{
  //error_reporting(0);
  global $mysqli;
  global $onerror;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $event_id = decode($data['id']);
    $user_arr = array();
    
    $check_data = $mysqli->prepare("SELECT `post_id`, `user_id`,  `title`, `description`,  `link`,`tags`,  `createtime` FROM `post_master` WHERE   post_id=? and type = 5 and delete_flag =0");
    $check_data->bind_param("i", $event_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($news_id,$user_id,$title,$description,$link,$tags, $createtime);
    
      $check_data->fetch();

      
$NewsUpdatesImages =getNewsUpdatesImages($news_id);
$NewsUpdatesVideos =getNewsUpdatesVideos($news_id);
$NewsUpdatespdf =getNewsUpdatesPdf($news_id);
     
      
          
     
      
      

      
   
    


      

      

      $createtime = date('d-m-Y h:i A', strtotime($createtime));
    
     

     
     

     

      


       

      

     





      $user_arr = array('news_id' => $news_id, 'title' => $title,  'createtime' => $createtime,'description'=>$description,'link'=>$link,'NewsUpdatesImages'=>$NewsUpdatesImages,'tags'=>$tags,'NewsUpdatesVideos'=>$NewsUpdatesVideos,'NewsUpdatespdf'=>$NewsUpdatespdf);
    }
    $record = array('success' => true, 'msg' => '', 'data' => $user_arr);
    return jsonSendEncodeAdmin($record);
  }
}


function getViewUsersRequirmentsData($data)
{
  //error_reporting(0);
  global $mysqli;
  global $onerror;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $event_id = decode($data['id']);
    $user_arr = array();
    
    $check_data = $mysqli->prepare("SELECT `post_id`, `user_id`,  `title`, `description`,  `product_ids`,`tags`,  `createtime` FROM `post_master` WHERE   post_id=? and type = 1 and delete_flag =0");
    $check_data->bind_param("i", $event_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($req_id,$user_id,$title,$description,$product_ids,$tags, $createtime);
    
      $check_data->fetch();
$productname =getProductName($product_ids);
      
$RequirementsImages =getNewsUpdatesImages($req_id);

      
          
     
      
      

      
   
    


      

      

      $createtime = date('d-m-Y h:i A', strtotime($createtime));
    
     

     
     

     

      


       

      

     





      $user_arr = array('req_id' => $req_id, 'title' => $title,  'createtime' => $createtime,'description'=>$description,'productname'=>$productname,'RequirementsImages'=>$RequirementsImages,'tags'=>$tags);
    }
    $record = array('success' => true, 'msg' => '', 'data' => $user_arr);
    return jsonSendEncodeAdmin($record);
  }
}

function getViewUsersShareImageData($data)
{
  //error_reporting(0);
  global $mysqli;
  global $onerror;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $event_id = decode($data['id']);
    $user_arr = array();
    
    $check_data = $mysqli->prepare("SELECT `post_id`, `user_id`,  `title`, `description`,  `link`,`tags`,  `createtime` FROM `post_master` WHERE   post_id=? and type = 6 and delete_flag =0");
    $check_data->bind_param("i", $event_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($req_id,$user_id,$title,$description,$link,$tags, $createtime);
    
      $check_data->fetch();

      
$ShareImages =getNewsUpdatesImages($req_id);

      
          
     
      
      

      
   
    


      

      

      $createtime = date('d-m-Y h:i A', strtotime($createtime));
    
     

     
     

     

      


       

      

     





      $user_arr = array('req_id' => $req_id, 'title' => $title,  'createtime' => $createtime,'description'=>$description,'link'=>$link,'ShareImages'=>$ShareImages,'tags'=>$tags);
    }
    $record = array('success' => true, 'msg' => '', 'data' => $user_arr);
    return jsonSendEncodeAdmin($record);
  }
}

function getViewUsersShareVideoData($data)
{
  //error_reporting(0);
  global $mysqli;
  global $onerror;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $event_id = decode($data['id']);
    $user_arr = array();
    
    $check_data = $mysqli->prepare("SELECT `post_id`, `user_id`,  `title`, `description`,  `link`,`tags`,  `createtime` FROM `post_master` WHERE   post_id=? and type = 7 and delete_flag =0");
    $check_data->bind_param("i", $event_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($video_id,$user_id,$title,$description,$link,$tags, $createtime);
    
      $check_data->fetch();

      

$ShareVideos =getNewsUpdatesVideos($video_id);

     
      
          
     
      
      

      
   
    


      

      

      $createtime = date('d-m-Y h:i A', strtotime($createtime));
    
     

     
     

     

      


       

      

     





      $user_arr = array('video_id' => $video_id, 'title' => $title,  'createtime' => $createtime,'description'=>$description,'link'=>$link,'tags'=>$tags,'ShareVideos'=>$ShareVideos);
    }
    $record = array('success' => true, 'msg' => '', 'data' => $user_arr);
    return jsonSendEncodeAdmin($record);
  }
}


function getViewUsersGroupData($data)
{
  //error_reporting(0);
  global $mysqli;
  global $onerror;
  include_once('language_message.php');
  if (empty($data['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $event_id = decode($data['id']);
    $user_arr = array();
    
    $check_data = $mysqli->prepare("SELECT `group_id`,`group_title`,`group_type`, `description`, `image`, `pincode`, `address`, `area`, `city`, `state`, `email`, `phone`, `website`, `additional_details`, `who_can_post_allow`, `membership`, `membership_type`, `membership_fees`, `createtime` FROM `group_master` WHERE   group_id=? and delete_flag =0");
    $check_data->bind_param("i", $event_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count <= 0) {
      $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
      return jsonSendEncodeAdmin($record);
    } else {
      $check_data->bind_result($group_id,$group_title,$group_type, $description, $image, $pincode, $address, $area, $city, $state, $email, $phone, $website, $additional_details, $who_can_post_allow, $membership, $membership_type, $membership_fees, $createtime);
    
      $check_data->fetch();

      if($group_type == 1){
        $group_type_text ='<label class="badge badge-primary">Trade Association</label>';
      }else{
         $group_type_text ='<label class="badge badge-info">Community</label>';
      }

      if($who_can_post_allow == 0){
        $post_allow ='<label class="badge badge-success">Admin</label>';
      }else{
          $post_allow ='<label class="badge badge-info">All</label>';
      }

      if($membership == 0){
        $membership_allow ='<label class="badge badge-success">Public</label>';
      }else{
          $membership_allow ='<label class="badge badge-info">Invite Only</label>';
      }

      if($membership_type == 0){
        $membership_type_text ='<label class="badge badge-success">Paid</label>';
      }else{
          $membership_type_text ='<label class="badge badge-warning">Free</label>';
      }

      $createtime = date('d-m-Y h:i A', strtotime($createtime));
    
    $user_arr = array('group_id' => $group_id, 'group_title' => $group_title,  'createtime' => $createtime,'description'=>$description,'image'=>$image,'pincode'=>$pincode,'address'=>$address,'area'=>$area,'city'=>$city,'state'=>$state,'email'=>$email,'phone'=>$phone,'website'=>$website,'additional_details'=>$additional_details,'membership_fees'=>$membership_fees,'post_allow'=>$post_allow,'membership_allow'=>$membership_allow,'membership_type_text'=>$membership_type_text,'group_type_text'=>$group_type_text);
    }
    $record = array('success' => true, 'msg' => '', 'data' => $user_arr);
    return jsonSendEncodeAdmin($record);
  }
}

function getRoleData()
{

  global $mysqli;
  include_once('language_message.php');
  include_once('common_functions_app.php');


  //$user_id = decode($data['user_id']);

  $result = $mysqli->prepare("SELECT `user_role_id`, `role` FROM user_role_master where delete_flag=0  ");
  $result->execute();
  $result->store_result();
  $row = $result->num_rows;
  if ($row <= 0) {
    $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $result->bind_result($user_role_id, $role);
    while ($result->fetch()) {
      $role_ary[]    =   array(
        'user_role_id'    =>  $user_role_id,
        'role'       =>  $role,


      );
    }
  }
  if (empty($role_ary)) {
    $role_ary = array();
  }
  $record = array('success' => true, 'data' => array('role_ary' => $role_ary));
  return jsonSendEncodeAdmin($record);
}



function getEquipmentData($data)
{

  global $mysqli;
  include_once('language_message.php');
  include_once('common_functions_app.php');
   include('site_config.php');

  $equipment_id = decode($data['equipment_id']);

  $result = $mysqli->prepare("SELECT `equipment_id`, `equipment_type_id`, `equipment_name`, `description`, `createtime`,`folder_no`,`equipment_history`,previous_inspection_date,inspection_due_date,components,inspection_finding,summary  FROM equipment_master where delete_flag=0 and equipment_id=?");
  $result->bind_param('i',$equipment_id);
  $result->execute();
  $result->store_result();
  $row = $result->num_rows;
  if ($row <= 0) {
    $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $result->bind_result($equipment_id, $equipment_type_id,$equipment_name,$description,$createtime,$folder_no,$equipment_history,$previous_inspection_date,$inspection_due_date,$components,$inspection_finding,$summary);
    $result->fetch();
    // if($attachment_file == ''){
    //      $attachment_html ='';
    //     }else{
    //          $attachment_html ="<a href=".$img_url_user_main2.$attachment_file." target='_blank'>View File</a>";
    //     }

       $getAttachment =getAttachment($equipment_id);
       $getCmpData =getCmpData($equipment_id);
      $equipment_ary    = array(
        'equipment_id'    =>  $equipment_id,
        'equipment_type_id'       =>  $equipment_type_id,
        'equipment_name'=>$equipment_name,
        'description'=>$description,
        'folder_no'=>$folder_no,
        'equipment_history'=>$equipment_history,
        'previous_inspection_date'=>$previous_inspection_date,'inspection_due_date'=>$inspection_due_date,'components'=>$components,'inspection_finding'=>$inspection_finding,'getCmpData'=>$getCmpData,'getAttachment'=>$getAttachment,'summary'=>$summary


      );
    
  }
  if (empty($equipment_ary)) {
    $equipment_ary = array();
  }
  $record = array('success' => true, 'data' =>  $equipment_ary);
  return jsonSendEncodeAdmin($record);
}



function getEquipmentDataAll()
{

  global $mysqli;
  include_once('language_message.php');
  include_once('common_functions_app.php');


  

  $result = $mysqli->prepare("SELECT `equipment_id`, `equipment_type_id`, `equipment_name`, `description`, `createtime`,`folder_no` FROM equipment_master where delete_flag=0 ");
  //$result->bind_param('i',$equipment_id);
  $result->execute();
  $result->store_result();
  $row = $result->num_rows;
  if ($row <= 0) {
    $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $result->bind_result($equipment_id, $equipment_type_id,$equipment_name,$description,$createtime,$folder_no);
    while($result->fetch()){
      $equipment_ary[]    =   array(
        'equipment_id'    =>  $equipment_id,
        'equipment_type_id'       =>  $equipment_type_id,
        'equipment_name'=>$equipment_name,
        'description'=>$description,
        'folder_no'=>$folder_no,


      );
    }
  }
  if (empty($equipment_ary)) {
    $equipment_ary = array();
  }
  $record = array('success' => true, 'data' =>array('equipment_ary' =>$equipment_ary));
  return jsonSendEncodeAdmin($record);
}


function getEquipmentTypeData()
{

  global $mysqli;
  include_once('language_message.php');
  include_once('common_functions_app.php');


  //$user_id = decode($data['user_id']);

  $result = $mysqli->prepare("SELECT `category_id`, `category_name` FROM category_master where delete_flag=0 order by  category_id desc");
  $result->execute();
  $result->store_result();
  $row = $result->num_rows;
  if ($row <= 0) {
    $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $result->bind_result($category_id, $category_name);
    while ($result->fetch()) {
      $cat_ary[]    =   array(
        'category_id'    =>  $category_id,
        'category_name'       =>  $category_name,


      );
    }
  }
  if (empty($cat_ary)) {
    $cat_ary = array();
  }
  $record = array('success' => true, 'data' => array('cat_ary' => $cat_ary));
  return jsonSendEncodeAdmin($record);
}



function getEquipmentTypeDataall($data)
{

  global $mysqli;
  include_once('language_message.php');
  include_once('common_functions_app.php');


  $equipment_type_id = decode($data['equipment_type_id']);
  $srno = 0;
  $result = $mysqli->prepare("SELECT `equipment_id`, `equipment_type_id`, `folder_no`, `equipment_name`, `description`,`createtime` FROM equipment_master where delete_flag=0 and equipment_type_id=? ");
  $result->bind_param('i',$equipment_type_id);
  $result->execute();
  $result->store_result();
  $row = $result->num_rows;
  if ($row <= 0) {
  
    $result->bind_result($equipment_id, $equipment_type_id,$folder_no,$equipment_name,$description,$createtime);
      $cat_name = getCategoryName($equipment_type_id);
       $cat_ary ='NA';
  } else {
    $result->bind_result($equipment_id, $equipment_type_id,$folder_no,$equipment_name,$description,$createtime);
    while ($result->fetch()) {

       $createtime = date('d-m-Y h:i A', strtotime($createtime));
       $cat_name = getCategoryName($equipment_type_id);
      $cat_ary[]    =   array(
        'equipment_id'    =>  $equipment_id,
        'equipment_type_id'       =>  $equipment_type_id,
        'folder_no'=>$folder_no,
        'equipment_name'=>$equipment_name,
        'description'=>$description,
        'createtime'=>$createtime,
        'cat_name'=>$cat_name,


      );
      $srno++;
    }
  }


  if (empty($cat_ary)) {
    $cat_ary ='NA';
  }
  $record = array('success' => true, 'data' => array('cat_ary' => $cat_ary,'cat_name'=>$cat_name));
  return jsonSendEncodeAdmin($record);
}


function getInspectionData($data)
{

  global $mysqli;
  include_once('language_message.php');
  include_once('common_functions_app.php');


  $inspection_id = decode($data['inspection_id']);

  $result = $mysqli->prepare("SELECT`inspection_id`, `user_id`, `equipment_type_id`, `equipment_id`, `inspection_type_id`, `inspection_title`, `description`, `inspection_date`,  `createtime`FROM inspection_master where delete_flag=0 and inspection_id=?");
  $result->bind_param('i',$inspection_id);
  $result->execute();
  $result->store_result();
  $row = $result->num_rows;
  if ($row <= 0) {
    $record = array('success' => false, 'msg' =>'', 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $result->bind_result($inspection_id,$user_id, $equipment_type_id,$equipment_id,$inspection_type_id,$inspection_title,$description,$inspection_date,$createtime);
    $result->fetch();

    $getInspectionDueDate =getInspectionDueDate($inspection_id);

     $result1 = $mysqli->prepare("SELECT `equipment_id`, `equipment_name` FROM equipment_master where delete_flag=0  and equipment_type_id =? order by  equipment_id desc");
      $result1->bind_param('i',$equipment_type_id);
  $result1->execute();
  $result1->store_result();
  $row1 = $result1->num_rows;
  if ($row1 <= 0) {
    $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $result1->bind_result($equipment_id, $equipment_name);
    while ($result1->fetch()) {
      $epq_ary[]    =   array(
        'equipment_id'    =>  $equipment_id,
        'equipment_name'       =>  $equipment_name,


      );
    }
  }
      $equipment_ary    =   array(
        'inspection_id'    =>  $inspection_id,
        'equipment_type_id'       =>  $equipment_type_id,
        'inspection_title'=>$inspection_title,
        'inspection_date'=>$inspection_date,
        'inspection_type_id'=>$inspection_type_id,
        'getInspectionDueDate' =>$getInspectionDueDate,
        'equipment_id'=>$equipment_id,
        'user_id'=>$user_id,
        'epq_ary'=>$epq_ary,
        'description'=>$description,


      );
    
  }
  if (empty($equipment_ary)) {
    $equipment_ary = array();
  }
  $record = array('success' => true, 'data' =>  $equipment_ary);
  return jsonSendEncodeAdmin($record);
}


function getMaintainanceData($data)
{

  global $mysqli;
  include_once('language_message.php');
  include_once('common_functions_app.php');


  $maintainance_id = decode($data['maintainance_id']);

  $result = $mysqli->prepare("SELECT `maintainance_id`, `equipment_type_id`, `equipment_id`, `maintainance_title`, `maintainance_date`, `maintainace_next_date`, `createtime` FROM maintainance_master where delete_flag=0 and maintainance_id=?");
  $result->bind_param('i',$maintainance_id);
  $result->execute();
  $result->store_result();
  $row = $result->num_rows;
  if ($row <= 0) {
    $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $result->bind_result($maintainance_id, $equipment_type_id,$equipment_id,$maintainance_title,$maintainance_date,$maintainace_next_date,$createtime);
    $result->fetch();


     $check_data1=$mysqli->prepare("SELECT `equipment_id`, `equipment_name` FROM `equipment_master`where delete_flag='0' and equipment_type_id=?");
 
    $check_data1->bind_param('i',$equipment_type_id);
    $check_data1->execute();
    $check_data1->store_result();
    $check_data_count1=$check_data1->num_rows;
    if($check_data_count1 >0) {
      $check_data1->bind_result($equipment_id,$equipment_name);
      while($check_data1->fetch()){
         //$createtime=date('d-m-Y h:i A',strtotime($createtime));
      
        $equipment_ary[] = array( 'equipment_id'=>$equipment_id,'equipment_name'=>$equipment_name);
        
      }
      $maintainance_ary    =   array(
        'maintainance_id'    =>  $maintainance_id,
        'equipment_type_id'       =>  $equipment_type_id,
        'equipment_id'=>$equipment_id,
        'maintainance_date'=>$maintainance_date,
        'maintainace_next_date'=>$maintainace_next_date,
        'maintainance_title'=>$maintainance_title,
        'equipment_ary'=>$equipment_ary


      );
    
  }
  if (empty($maintainance_ary)) {
    $maintainance_ary = array();
  }
  $record = array('success' => true, 'data' =>  $maintainance_ary);
  return jsonSendEncodeAdmin($record);
}
}


function getUserEnginnerData()
{

  global $mysqli;
  include_once('language_message.php');
  include_once('common_functions_app.php');


  //$user_id = decode($data['user_id']);

  $result = $mysqli->prepare("SELECT `user_id`, `name`,`mobile` FROM user_master where delete_flag=0 and user_type =1 and role_id =1 order by  user_id desc");
  $result->execute();
  $result->store_result();
  $row = $result->num_rows;
  if ($row <= 0) {
    $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $result->bind_result($user_id, $name,$mobile);
    while ($result->fetch()) {
      $user_ary[]    =   array(
        'user_id'    =>  $user_id,
        'name'       =>  $name,
        'mobile'=>$mobile,


      );
    }
  }
  if (empty($user_ary)) {
    $user_ary = array();
  }
  $record = array('success' => true, 'data' => array('user_ary' => $user_ary));
  return jsonSendEncodeAdmin($record);
}


function getInspectionTypeData()
{

  global $mysqli;
  include_once('language_message.php');
  include_once('common_functions_app.php');


  //$user_id = decode($data['user_id']);

  $result = $mysqli->prepare("SELECT `inspection_type_id`, `inspection_type` FROM inspection_type_master where delete_flag=0 order by  inspection_type_id desc");
  $result->execute();
  $result->store_result();
  $row = $result->num_rows;
  if ($row <= 0) {
    $record = array('success' => false, 'msg' => $msgInvalidId, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $result->bind_result($inspection_type_id, $inspection_type);
    while ($result->fetch()) {
      $ins_ary[]    =   array(
        'inspection_type_id'    =>  $inspection_type_id,
        'inspection_type'       =>  $inspection_type,


      );
    }
  }
  if (empty($ins_ary)) {
    $ins_ary = array();
  }
  $record = array('success' => true, 'data' => array('ins_ary' => $ins_ary));
  return jsonSendEncodeAdmin($record);
}


function getInspectionDataByID($data)
{
  global $mysqli;
  global $onerror;
  include_once('language_message.php');
  if (empty($_GET['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $inspection_id = decode($_GET['id']);
    $srno = 1;
    $check_data = $mysqli->prepare("SELECT  `inspection_id`,`user_id`, `equipment_type_id`,`equipment_id`, `inspection_type_id`, `inspection_title`, `inspection_date`,`description`, `createtime` FROM `inspection_master` WHERE delete_flag='0' and inspection_id=? ");
    $check_data->bind_param("i", $inspection_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count > 0) {
      $check_data->bind_result($inspection_id,$user_id, $equipment_type_id,$equipment_id, $inspection_type_id,$inspection_title,$inspection_date,$description,$createtime);
      $check_data->fetch();

      //echo $inspection_date;

      $createtime = date('d-m-Y h:i A', strtotime($createtime));
        $inspection_date = date('d-m-Y', strtotime($inspection_date));
         $equipment_name = getEquipmentNameall($equipment_id);
        $equipmentTypeName = getCategoryName($equipment_type_id);
        $inspection_type_name =getInspectionTypeName($inspection_type_id);

        $getAllInspectionDueDate =getAllInspectionDueDate($inspection_id);
         $getAllInspectionDueDate = date('d-m-Y', strtotime($getAllInspectionDueDate));
        $getInspectionDueDate =getInspectionDueDate($inspection_id);
       
         $userData = getUserDetails($user_id);
         if($userData != 'NA'){
              $userName =$userData['name'];
              $userMobile =$userData['mobile'];
              $userEmail =$userData['email'];
              $userImage =$userData['image'];
              $image_html = '<img  width="50px" src="../webservice/images/' . $userImage . '" class="rounded-circle circle-border m-b-md img-fix img-responsive" name="profile_image" id="previewholder" style="width: 70px; height: 70px;" alt="" onerror="this.src=' . $onerror . ';" >';
         }else{
           $userName ='NA';
             $userMobile ='NA';
              $userEmail ='NA';
              $image_html ='NA';
         }
      $user_arr = array('srno' => $srno, 'inspection_id' => $inspection_id, 'inspection_title' => $inspection_title, 'createtime' => $createtime,'equipmentTypeName'=>$equipmentTypeName,'inspection_date'=>$inspection_date,'equipment_name'=>$equipment_name,'userName'=>$userName,'inspection_type_name'=>$inspection_type_name,'userMobile'=>$userMobile,'userEmail'=>$userEmail,'image_html'=>$userImage,'description'=>$description,'getAllInspectionDueDate'=>$getAllInspectionDueDate,'getInspectionDueDate'=>$getInspectionDueDate,'inspection_type_id'=>$inspection_type_id);
    }
    if (empty($user_arr)) {
      $user_arr = array();
    }
    $record = array('success' => true, 'data' => $user_arr);
    return jsonSendEncodeAdmin($record);
  }
}
//------------------------get user data ---------------------------------------//

function getInspectionHistoryDataByID($data)
{
  global $mysqli;
  global $onerror;
  include_once('language_message.php');
  if (empty($_GET['id'])) {
    $record = array('success' => false, 'msg' => $msgEmptyAll, 'data' => array());
    return jsonSendEncodeAdmin($record);
  } else {
    $inspection_id = decode($_GET['id']);
    $srno = 1;
    $check_data = $mysqli->prepare("SELECT `inspection_request_id`, `inspection_id`, `user_id`, `inspection_type_id`, `inspection_title`, `inspection_date`,createtime from inspection_request_master  WHERE delete_flag='0' and inspection_request_id=? ");
    $check_data->bind_param("i", $inspection_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count = $check_data->num_rows;
    if ($check_data_count > 0) {
      $check_data->bind_result($inspection_request_id, $inspection_id, $user_id, $inspection_type_id, $inspection_title, $inspection_date,$createtime );
      $check_data->fetch();

      $createtime = date('d-m-Y h:i A', strtotime($createtime));
        $inspection_date = date('d-m-Y', strtotime($inspection_date));
        
        $inspection_type_name =getInspectionTypeName($inspection_type_id);

        $getAllInspectionDueDate =getAllInspectionHistoryDueDate($inspection_request_id);
        $getAllInspectionHistoryImage =getAllInspectionHistoryImage($inspection_request_id);
       
         $userData = getUserDetails($user_id);
         if($userData != 'NA'){
              $userName =$userData['name'];
              $userMobile =$userData['mobile'];
              $userEmail =$userData['email'];
              $userImage =$userData['image'];
              $image_html = '<img  width="50px" src="../webservice/images/' . $userImage . '" class="rounded-circle circle-border m-b-md img-fix img-responsive" name="profile_image" id="previewholder" style="width: 70px; height: 70px;" alt="" onerror="this.src=' . $onerror . ';" >';
         }else{
           $userName ='NA';
             $userMobile ='NA';
              $userEmail ='NA';
              $image_html ='NA';
         }
      $user_arr = array('srno' => $srno, 'inspection_id' => $inspection_id, 'inspection_title' => $inspection_title, 'createtime' => $createtime,'inspection_date'=>$inspection_date,'userName'=>$userName,'inspection_type_name'=>$inspection_type_name,'userMobile'=>$userMobile,'userEmail'=>$userEmail,'image_html'=>$userImage,'getAllInspectionDueDate'=>$getAllInspectionDueDate,'inspection_type_id'=>$inspection_type_id,'getAllInspectionHistoryImage'=>$getAllInspectionHistoryImage);
    }
    if (empty($user_arr)) {
      $user_arr = array();
    }
    $record = array('success' => true, 'data' => $user_arr);
    return jsonSendEncodeAdmin($record);
  }
}



function getViewUsersData3($data) {
  error_reporting(0);
  global $mysqli;
  include_once('language_message.php');
  if(empty($data['id'])) {
    $record=array('success'=>false, 'msg'=>$msgEmptyAll, 'data'=>array());
    return jsonSendEncodeAdmin($record);
  } else {
    $user_id = decode($data['id']);
    $user_arr = array();

    
    $check_data=$mysqli->prepare("SELECT `user_id`, `name`, `email`, `image`,`active_flag`,`previlages`,`createtime` ,`updatetime` FROM `user_master` WHERE  delete_flag='0' and user_type = '2' and user_id=?");
    $check_data->bind_param("i",$user_id);
    $check_data->execute();
    $check_data->store_result();
    $check_data_count=$check_data->num_rows;
    if($check_data_count <=0) {
      $record=array('success'=>false,'msg'=>$msgInvalidId,'data'=>array());
      return jsonSendEncodeAdmin($record);
    }else{
      $check_data->bind_result($user_id,$name,$email,$image,$active_flag,$previlages,$createtime,$updatetime);
      $check_data->fetch();

      $createtime=date('M-d-Y h:i A',strtotime($createtime));
      $updatetime=date('M-d-Y h:i A',strtotime($updatetime));


        if($active_flag == '1'){
          $active_flag_text = '0';
          $active_flag_html = ' <span class="badge rounded-pill bg-success inv-badge">Activate</span>';
        }else{
          $active_flag_text = '1';
          $active_flag_html = '<span class="badge rounded-pill bg-danger inv-badge">Deactivate</span>';
        }
        $previlages_ary =explode(',',$previlages);

      
     
    $user_arr = array('name'=>$name,'email'=>$email,'image'=>$image,'createtime'=>$createtime,'active_flag'=>$active_flag_html,'previlages_ary'=>$previlages_ary,'user_id'=>$user_id);
    }
    $record=array('success'=>true, 'msg'=>$msgDataFound, 'data'=>$user_arr);
    return jsonSendEncodeAdmin($record);
  }
}






















