<?php 

include('libraryPHP/site_config.php');

include('libraryPHP/session_check_url.php');





?>

<!DOCTYPE html>

<html lang="en">



<head>

    <meta charset="utf-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">

    <title><?php echo $appName?> | <?php echo $pageTitle?></title>

<?php echo $appFaviconHtml?>    

    <!-- theme css start -->

    <?php include("commoncss.php"); ?>

    <!-- theme css end -->



</head>



<body>



    <!-- Main Wrapper -->

    <div class="main-wrapper">



        <!-- Header start  -->

        <?php include("header.php"); ?>

        <!-- /Header end -->



        <!-- Sidebar -->

        <?php include("sidebar.php"); ?>

        <!-- /Sidebar -->



        <!-- Page Wrapper -->

        <div class="page-wrapper">



            <div class="content container-fluid">



                <!-- Page Header -->

                <div class="page-header">

                    <div class="row">

                        <div class="col">

                            <h3 class="page-title">User Analytical Report</h3>

                            <ul class="breadcrumb">

                                <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>

                                <li class="breadcrumb-item active">User  Analytical Report</li>

                            </ul>

                        </div>

                    </div>

                </div>

                <!-- /Page Header -->



                <!-- start write start -->

                <div class="row">

                    <div class="col-lg-12">

                        <div class="card-box">

                            <center>

                                <h3>

                                    <?php echo date('Y'); ?> Monthly Analytical Reports of  Users

                                </h3>

                            </center>

                            <div id="chartmonthdiv"></div>

                        </div> <!-- end card-box-->

                    </div> <!-- end col -->

                </div>



                <!-- end row -->

                <div class="row">

                    <div class="col-lg-12">

                        <div class="card-box">

                            <center>

                                <h3>

                                    <?php echo date('Y'); ?> Yearly Analytical Reports of  Users

                                </h3>

                            </center>

                            <div id="chartyeardiv"></div>

                        </div> <!-- end card-box-->

                    </div> <!-- end col -->

                </div>

                <!-- end row -->



                <!-- start write end -->

            </div>

        </div>

        <!-- /Page Wrapper -->

        <!-- footer start -->

        <?php include("footer.php"); ?>

        <!-- footer end -->



    </div>

    <!-- /Main Wrapper -->



    <!-- sctipt start  -->

   <?php include('commonjs.php')?>

        <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>


      <!-- extra js -->

        <?php include_once('extrajs.php') ?>


        <script type = "text/javascript" src = "https://www.gstatic.com/charts/loader.js"></script>
    
    <script type="text/javascript">
    $(document).ready(function() {
       // App.init();
       //-----------------------Month---------------------//
        google.charts.load('current', {'packages':['corechart']});
        google.charts.setOnLoadCallback(getAnalaticUserReportMonthly);
    
        //-----------------------Month---------------------//
        google.charts.load('current', {'packages':['corechart']});
        google.charts.setOnLoadCallback(getAnalaticUserReportYearly);
        
        
    });
    
    function getAnalaticUserReportMonthly(){
    
        var link = URLAPI+'report_controller.php';
        var type = 'monthly';
        var data = {
            action:'analytic_report_users',
            type:type,
        }
    
        var messsage = msgLoading.blankMessage[language];
        console.log('messsage',messsage);
        
        apiRequest.get(link, data, messsage).then(function(obj){
            console.log('obj',obj);
            if(obj.success === true) {
                getAnalaticUserReportShow(type, obj);
            } else {
                //------------ Operation Message --------------------
                var title = msgTitleOperation.userDeleted[language];
                var messsage = obj.msg[language];
                //msgSuccessErrorHtml.error(title, messsage, msgSuccessErrorHtmlSelector);
                swal({
                    title: title,
                    text: messsage,
                    icon: "error", //error, success, info
                    button: "Ok",
                }).then((value) => {
                    window.location.href="#";
                });
                //------------ Operation Message End--------------------
                return false;
            }
        },function(err){
            console.log('err',err); 
            //alert('Server not responde');
    
            //------------ Operation Message --------------------
            var title = msgTitleOperation.errorOnServer[language];
            var messsage = msgOperations.errorOnServer[language];
            //msgSuccessErrorHtml.warning(title, messsage, msgSuccessErrorHtmlSelector);
            swal({
                    title: title,
                    text: messsage,
                    icon: "warning", //error, success, info
                    button: "Ok",
                }).then((value) => {
                    window.location.href="#";
                });
            //------------ Operation Message End--------------------
            return false;       
        });
    
    }
    
    function getAnalaticUserReportYearly(){
    
        var link = URLAPI+'report_controller.php';
        var type = 'yearly';
        var data = {
            action:'analytic_report_users',
            type:type,
        }
    
        var messsage = msgLoading.blankMessage[language];
        console.log('messsage',messsage);
        
        apiRequest.get(link, data, messsage).then(function(obj){
            console.log('obj',obj);
            if(obj.success === true) {
                getAnalaticUserReportShow(type, obj);
            } else {
                //------------ Operation Message --------------------
                var title = msgTitleOperation.userDeleted[language];
                var messsage = obj.msg[language];
                msgSuccessErrorHtml.error(title, messsage, msgSuccessErrorHtmlSelector);
                swal({
                    title: title,
                    text: messsage,
                    icon: "error", //error, success, info
                    button: "Ok",
                }).then((value) => {
                    window.location.href="#";
                });
                //------------ Operation Message End--------------------
                return false;
            }
        },function(err){
            console.log('err',err); 
            //alert('Server not responde');
    
            //------------ Operation Message --------------------
            var title = msgTitleOperation.errorOnServer[language];
            var messsage = msgOperations.errorOnServer[language];
            msgSuccessErrorHtml.warning(title, messsage, msgSuccessErrorHtmlSelector);
            swal({
                    title: title,
                    text: messsage,
                    icon: "warning", //error, success, info
                    button: "Ok",
                }).then((value) => {
                    window.location.href="#";
                });
            //------------ Operation Message End--------------------
            return false;       
        });
    
    }
    
    function getAnalaticUserReportShow(type, obj){
        console.log('getAnalaticUserReportShow type',type);
        console.log('getAnalaticUserReportShow obj',obj);
    
        if(type == 'monthly'){ 
    
            var jsondata = obj.data;
            //console.log('jsondata',jsondata);
    
            var data = new google.visualization.DataTable();
    
            data.addColumn('string', 'Month');
            data.addColumn('number', 'Total Users');
            
            
            $.each(jsondata,function(i,indexvalue){
                var month = indexvalue.month;
                var users = indexvalue.users;
                data.addRows([[month,users]]);
            })
            var options = {
                title:'',
                hAxis:{
                    title:'Month',
                },
                vAxis:{
                    title:'Leads IMS',
                },
                seriesType: 'bars',
                series: {
                    0:{color:'#3906A5'},
                  }
            };
            var chart = new google.visualization.ComboChart(document.getElementById('chartmonthdiv'));
            chart.draw(data, options);
        }else if(type == 'yearly'){
    
            jsondata = obj.data;
            var data = new google.visualization.DataTable();
    
            data.addColumn('string', 'Years');
            data.addColumn('number', 'Total  Users');
            
            $.each(jsondata,function(i,indexvalue){
                var year = String(indexvalue.year);
                var users = indexvalue.users;
                data.addRows([[year,users]]);
            })
            var options = {
                title:'',
                hAxis:{
                    title:'Years',
                },
                vAxis:{
                    title:'Leads IMS',
                },
                seriesType: 'bars',
                series: {
                    0:{color:'#3906A5'},
                  }
            };
            var chart = new google.visualization.ComboChart(document.getElementById('chartyeardiv'));
            chart.draw(data, options);
        }
    }
    
    </script> 









</body>



</html>