
<?php 

include('libraryPHP/site_config.php');

include('libraryPHP/session_check_url.php');
if($_SESSION['user_type'] != 0){
        echo '<script>window.location="dashboard.php";</script>';
    exit();
}

?>


<!DOCTYPE html>
<html>
<head>
    <?php include('include/head.php'); ?>
</head>
<body>
    <?php include('include/header.php'); ?>
    <?php include('include/sidebar.php'); ?>
    <div class="main-container">
        <div class="pd-ltr-20 xs-pd-20-10">
            <div class="min-height-200px">
                <div class="page-header">
                    <div class="row">
                        <div class="col-md-6 col-sm-12">
                            <div class="title">
                                <h4>Tabular Deal Moderator Report</h4>
                            </div>
                            <nav aria-label="breadcrumb" role="navigation">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                    <li class="breadcrumb-item"><a href="#">Tabular Deal Moderator Report</a></li>

                                </ol>
                            </nav>
                        </div>
                        
                    </div>
                </div>
                
            

                <!-- horizontal Basic Forms Start -->
                     <form action="" method="POST" id="validate_tabular_vendor_report">

                                        
                    <div class="row">
                        
                         <input required="required" type="hidden" id="action" name="action" value="show_tabular_vendor_moderator_report">

                        <div class="col-md-5">
                            <label class="m-t-15">Start Date</label>
                            <div class="input-group">
                                <input type="date" class="form-control" name="s_date" id="fromDate" placeholder="mm/dd/yyyy" autocomplete="off" value=" ">
                                <div class="input-group-append">
                                    <span class="flaticon-calendar" style="margin: 8px;"></span>
                                </div>
                            </div>
                           
                        </div>
                         <label id="fromDate-error" class="error" for="s_date"></label>
                        <div class="col-md-5">
                            <label class="m-t-15">End Date</label>
                            <div class="input-group">
                                <input type="date" class="form-control" name="e_date" id="toDate" placeholder="mm/dd/yyyy" autocomplete="off" value=" ">
                                <div class="input-group-append">
                                    <span class="flaticon-calendar" style="margin: 8px;"></span>
                                </div>
                            </div>
                             
                        </div>
                        <label id="toDate-error" class="error" for="e_date"></label>
                        <div class="form-group" class="col-md-3" style="padding: 32px;">
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                    </div>
                </form>
                <!-- horizontal Basic Forms End -->

                 <div class="row" id="showempty" style="display: none;">
                              <h4>No records found!</h4>
                             </div>


                   <div class="row" id="showtraveler" style="display: none;">

                                <div class="col-12">

                                    <div class="card m-b-20">

                                        <div class="card-body">

            

                                            <h4 class="mt-0 header-title">Deal List</h4>

            

                                            <div class="table-rep-plugin">

                                                <div class="table-responsive b-0" data-pattern="priority-columns">

                                                    <table id="table_vendorreport" class="table table-bordered  table-striped">

                                                        <thead>

                                                         <tr>
                                                           <th>S.No.</th>
                                                           <th>S.No.</th>
                                                           <th>UserName</th>
                                                           <th>VendorName</th>
                                                           <th>Comment</th>
                                                          
                                                           <th>Status</th>
                                                          <!-- <th>UserType</th> -->
                                                          <th>Change Status By</th>
                                                          <th>Name</th>
                                                          <th>Actiondatetime</th> 
                                                        </tr>

                                                        </thead>

                                                    </table>

                                                </div>

            

                                            </div>

            

                                        </div>

                                    </div>

                                </div> <!-- end col -->

                            </div> <!-- end row -->   



                

            </div>
            <?php include('include/footer.php'); ?>
        </div>
    </div>
    <?php include('include/script.php'); ?>

    <!-- extra js -->
    <?php include_once('extrajs.php'); ?>


     <script src="src/plugins/datatables/js/jquery.dataTables.min.js"></script>
    <script src="src/plugins/datatables/js/dataTables.bootstrap4.min.js"></script>
    <script src="src/plugins/datatables/js/dataTables.responsive.min.js"></script>
    <script src="src/plugins/datatables/js/responsive.bootstrap4.min.js"></script>
    <!-- buttons for Export datatable -->
    <script src="src/plugins/datatables/js/dataTables.buttons.min.js"></script>
    <script src="src/plugins/datatables/js/buttons.bootstrap4.min.js"></script>
    <script src="src/plugins/datatables/js/buttons.print.min.js"></script>
    <script src="src/plugins/datatables/js/buttons.html5.min.js"></script>
    <script src="src/plugins/datatables/js/buttons.flash.min.js"></script>
    <script src="src/plugins/datatables/js/pdfmake.min.js"></script>
    <script src="src/plugins/datatables/js/vfs_fonts.js"></script>
    <!-- Datatable Setting js -->
    <script src="vendors/scripts/datatable-setting.js"></script>


         <script type="text/javascript">
            function allUser(){
                 $('.users_div').hide();
               // $("#users").hide();
            }
            function myFun(){
                  $('.users_div').show();
                //$("#users").show();
            }
      </script>
    <script>
      $(function () {
        //Initialize Select2 Elements
        $('.select2').select2()
    
        //Initialize Select2 Elements
        $('.select2bs4').select2({
          theme: 'bootstrap4'
        })
      })

    </script>

    <script>
        
      $(function() {

          // Initialize form validation on the registration form.

          // It has the name attribute "registration"

          $("#validate_tabular_vendor_report").validate({

            // Specify validation rules

            rules: {

              // The key name on the left side is the name attribute

              // of an input field. Validation rules are defined

              // on the right side

              s_date: "required",

              e_date: {

                required: true

              },

        

        

            },

            // Specify validation error messages

            messages: {

             s_date: "Please enter from date",

              e_date: {

                required: "Please enter to date"

            }

            },

            // Make sure the form is submitted to the destination defined

            // in the "action" attribute of the form when valid

            submitHandler: function(form) {

                    /*form.submit();*/

                    var link = URLAPI+'report_controller.php';

                    //var data=$(form).serialize();

                    var data = new FormData($(form)[0]);

                    var messsage = msgLoading.blankMessage[language];

                    console.log('messsage',messsage);

                 apiRequest.postFile(link, data, messsage).then(function(obj){

                console.log('obj',obj);

                if(obj.success === true) {

                    var deal_arr =  obj.deal_arr;

                   console.log('deal_arr', deal_arr);

                   if(deal_arr == null || deal_arr == ''){
                     $('#showempty').show();
                      $('#showtraveler').hide();

                   }else{


                    if(deal_arr.length>0){

                        $('#showtraveler').show();
                         $('#showempty').hide();

                        $('#table_vendorreport').DataTable( {

                            data: deal_arr,

                            "destroy": true,

                            "paging": true,

                            "lengthChange": true,

                            "searching": true,

                            "ordering": true,

                            "info": true,

                            "autoWidth": false,

                            "responsive": true,

                            "aaSorting": [

                                [ 0 , "asc"]

                            ],

                            "bJQueryUI":  "true" ,

                            "sPaginationType": "full_numbers",

                            "iDisplayLength": 5,

                            "aLengthMenu": [

                                [5, 10, 25, 50, 100, 200, -1],

                                [5, 10, 25, 50, 100, 200, "All"]

                            ],

                            "columns": [
                                { "data": "srno" },
                                { "data": "username" },
                                 {"data":"vendorname"},
                                {"data":'comment'},
                                { "data": "status" },
                                 { "data": "ustype" },

                                 { "data": "moderator" },
                                { "data": "createtime" },
                                

                                
                            ],

                            "rowId": "user_id",

                        });

                    }

                   }


                } else {

                    //------------ Operation Message --------------------

                    var title = msgTitleOperation.blankMessage[language];

                    var messsage = obj.msg[language];

                    msgSuccessErrorHtml.error(title, messsage, msgSuccessErrorHtmlSelector);

                    //------------ Operation Message End--------------------

                    return false;

                }

            },function(err){

                console.log('err',err);

                //alert('Server not responde');

        

                //------------ Operation Message --------------------

                var title = msgTitleOperation.errorOnServer[language];

                var messsage = msgOperations.errorOnServer[language];

                msgSuccessErrorHtml.warning(title, messsage, msgSuccessErrorHtmlSelector);

                //------------ Operation Message End--------------------

                return false;

            });

                }

          });

        });



    </script>

</body>
</html>