<?php 

include('libraryPHP/site_config.php');

include('libraryPHP/session_check_url.php');





?>


<!DOCTYPE html>

<html lang="en">



<head>

    <meta charset="utf-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">

    <title><?php echo $appName?> | <?php echo $pageTitle?></title>



    <!-- theme css start -->

    <?php include("theme_css.php"); ?>

    <!-- theme css end -->



</head>



<body>



    <!-- Main Wrapper -->

    <div class="main-wrapper">



        <!-- Header start  -->

        <?php include("header.php"); ?>

        <!-- /Header end -->



        <!-- Sidebar -->

        <?php include("sidebar.php"); ?>

        <!-- /Sidebar -->



        <!-- Page Wrapper -->

        <div class="page-wrapper">



            <div class="content container-fluid">



                <!-- Page Header -->

                <div class="page-header">

                    <div class="row">

                        <div class="col">

                            <h3 class="page-title">Manage Sub Admin</h3>

                            <ul class="breadcrumb">

                                <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>

                                <li class="breadcrumb-item active">Manage Sub Admin</li>

                            </ul>

                        </div>

                    </div>

                </div>

                <!-- /Page Header -->



                <!-- start write start -->

                <div class="col-12">



                    <div class="card">



                        <div class="card-body">

                            <div class="row">   
                                <div class="col-sm-4">  </div>
                                <div class="col-sm-4">  </div>
                                <div class="col-sm-2">  </div>
                                <div class="col-sm-2 mb-2"> 
                                <a class="btn btn-primary ml-3" href="add_subadmin.php">Add Sub Admin</button> </a>
                            </div>



                            <div class="table-responsive">



                                <table id="table_manage_user" class="table table-hover table-bordered" style="border-collapse: collapse; border-spacing: 0; width: 100%;">



                                    <thead>



                                        <tr>



                                            <th>S.No.</th>
                                              <th>Action</th>

                                            <th>Image</th>

                                            <th> Name</th>

                                            <th>Email</th>


                                         

                                          

                                          

                                            <th>Status</th>

                                            <th>Create Date & Time</th>

                                          



                                        </tr>



                                    </thead>

                                   



                                </table>



                            </div>



                        </div>



                    </div>



                </div> <!-- end col -->



                <!-- start write end -->

            </div>

        </div>

        <!-- /Page Wrapper -->

        <!-- footer start -->

        <?php include("footer.php"); ?>

            <!-- footer end -->



    </div>

    <!-- /Main Wrapper -->



    <!-- sctipt start  -->

    <?php include('commonjs.php')?>

        <?php include_once('extrajs.php') ?>
<script>

   function btnReset(){
     $('form#add_driver_form').trigger("reset");
     $('#image-holder1').attr('src',' ');
   
  }  
  var table = '';


   $(document).ready(function() {


    
    $('#table_manage_user').DataTable();
   getUserTable('first', 'all');

     

            });
        
            
 

   
   </script>

   <script>
      function getUserTable(event, type){
            if(event != 'first'){
                $('.view_class').removeClass('active').prop('disabled',false);
                $(event).addClass('active').prop('disabled',true);
            }
        
          
            var link = URLAPI+'user_controller.php';
        
            var data = {
                action:'get_subadmin',
                type:type,
               

            }
        
            var messsage = msgLoading.blankMessage[language];
            console.log('messsage',messsage);
        
            apiRequest.get(link, data, messsage).then(function(obj){
                console.log('obj',obj);
                if(obj.success === true) {
                    var user_arr =  obj.data.user_arr;
                    if(user_arr.length>=0){
                        //table.destroy();
                        //$('#table_users').empty();
                        $('#table_manage_user').DataTable({
                            data: user_arr,
                            "destroy": true,
                            "paging": true,
                            "lengthChange": true,
                            "searching": true,
                            "ordering": true,
                            "info": true,
                            "autoWidth": false,
                            "responsive": true,
                            "aaSorting": [
                                [ 0 , "asc"]
                            ],
                            "bJQueryUI":  "true" ,
                            "sPaginationType": "full_numbers",
                            "iDisplayLength": 5,
                            "aLengthMenu": [
                                [5, 10, 25, 50, 100, 200, -1],
                                [5, 10, 25, 50, 100, 200, "All"]
                            ],
                            "columns": [
                                //  { "data": "select" },
                                { "data": "srno" },
                                 { "data": "action"},
                                  { "data": "image" },
                              
                                { "data": "name" },
                            
                                {"data":"email"},
                              
                               
                                { "data": "active_flag" },
                               
                                                            
                                 { "data": "createtime" },
                               
                            ],
                            "rowId": "user_id",
                        });
                    }else{
                        dataTable.fnClearTable();
                            dataTable.fnDraw();
                            dataTable.fnDestroy();
                    }
                } else {
        
                    //------------ Operation Message --------------------
                    var title = msgTitleOperation.blankMessage[language];
                    var messsage = obj.msg[language];
                    msgSuccessErrorHtml.error(title, messsage, '#msgSuccessErrorHtml');
                    //------------ Operation Message End--------------------
                    return false;
                }
            },function(err){
                console.log('err',err);
        
                //------------ Operation Message --------------------
                var title = msgTitleOperation.errorOnServer[language];
                var messsage = msgOperations.errorOnServer[language];
                msgSuccessErrorHtml.warning(title, messsage, '#msgSuccessErrorHtml');
                //------------ Operation Message End--------------------
                return false;
            });
        }

           function btnUserActivateDeactivateConfirm(event){
        
            var user_id = $(event).attr('data-id');
        
            var status = $(event).attr('data-user-status');
            console.log('status',status);
            if(status == '1'){
                var text =   msgConfim.subadminActivated[language];
            }else{
                var text =   msgConfim.subadminDeactivated[language];
    
            }
        
            swal({
              title:'',
              text: text,
              icon: "warning", //error, success, info
              buttons:  ["Cancel", "Ok"],
            })
            .then((willDelete) => {
              if (willDelete) {
                 btnUserActivateDeactivateContinue(event, user_id, status);
              } else {
                //swal("Your imaginary file is safe!");
              }
            });
        }
        
        function  btnUserActivateDeactivateContinue(event, user_id, active_flag){
        //   alert(active_flag);
            var link = URLAPI+'user_controller.php';
            var data = {
                action:'activate_deactivate_subadmin',
                user_id:user_id,
                active_flag:active_flag,
            }
        
            var messsage = msgLoading.blankMessage[language];
            console.log('messsage',messsage);
        
            apiRequest.get(link, data, messsage).then(function(obj){
                console.log('obj',obj);
                if(obj.success === true) {

        
                    //------------ Operation Message --------------------
                    if(active_flag == '0'){
                        var title =   msgTitleOperation.blankMessage[language];
                    }else{
                        var title =   msgTitleOperation.blankMessage[language];
                    }
                    var messsage = obj.msg[language];
                    msgSuccessErrorHtml.success(title, messsage, msgSuccessErrorHtmlSelector);
                    //------------ Operation Message End--------------------
                    swal({
                        title: title,
                        text: messsage,
                        icon: "success", //error, success, info
                        button: "Ok",
                    }).then((value) => {
                        window.location.href="#";
                      // getUserTable('first', 'all');
                    });
        
                    // //-------------- DataTable Row Action -----------------
                    $('#table_manage_user').dataTable().fnUpdate(obj.data.active_flag_html , $('tr#'+user_id),5, false);
                    $('#table_manage_user').dataTable().fnUpdate(obj.data.action_html , $('tr#'+user_id),1, false);
                    //-------------- DataTable Row Action end -----------------
        
                    return false;
        
                } else {
                    //------------ Operation Message --------------------
                    var title = msgTitleOperation.blankMessage[language];
                    var messsage = obj.msg[language];
                    msgSuccessErrorHtml.error(title, messsage, msgSuccessErrorHtmlSelector);
                    swal({
                        title: title,
                        text: messsage,
                        icon: "error", //error, success, info
                        button: "Ok",
                    }).then((value) => {
                        window.location.href="#";
                    });
                    //------------ Operation Message End--------------------
                    return false;
                }
            },function(err){
                console.log('err',err);
                //alert('Server not responde');
        
                //------------ Operation Message --------------------
                var title = msgTitleOperation.errorOnServer[language];
                var messsage = msgOperations.errorOnServer[language];
                msgSuccessErrorHtml.error(title, messsage, msgSuccessErrorHtmlSelector);
                    swal({
                        title: title,
                        text: messsage,
                        icon: "error", //error, success, info
                        button: "Ok",
                    }).then((value) => {
                        window.location.href="#";
                    });
                //------------ Operation Message End--------------------
                return false;
            });
        }

        function btnUserDeleteConfirm(event){
            var user_id = $(event).attr('data-id');
            swal({
              title: '',
              text: 'Are you sure want to delete  SubAdmin?',
              icon: "warning", //error, success, info
              buttons:  ["Cancel", "Ok"],
              //dangerMode: true,
            })
            .then((willDelete) => {
              if (willDelete) {
                btnUserDeleteContinue(event, user_id);
              } else {
                //swal("Your imaginary file is safe!");
              }
            });
        }


        function btnUserDeleteContinue(event, user_id){
    
        var link = URLAPI+'user_controller.php';
        var data = {
            action:'delete_user',
            user_id:user_id,
        }
    
        var messsage = msgLoading.blankMessage[language];
        console.log('messsage',messsage);
        
        apiRequest.get(link, data, messsage).then(function(obj){
            console.log('obj',obj);
            if(obj.success === true) { 
            var title = '';
            var messsage = obj.msg[language];
            var messsage = obj.msg[language];
            swal_alert(title,messsage,"#","success");
             getUserTable('first', 'all');
            //-------------- DataTable Row Action end ---------
            return false;
                
    
            } else {
                //------------ Operation Message --------------------
                var title = msgTitleOperation.userDeleted[language];
                var messsage = obj.msg[language];
                msgSuccessErrorHtml.error(title, messsage, msgSuccessErrorHtmlSelector);
                //------------ Operation Message End--------------------
                return false;
            }
        },function(err){
            console.log('err',err); 
            //alert('Server not responde');
    
            //------------ Operation Message --------------------
            var title = msgTitleOperation.errorOnServer[language];
            var messsage = msgOperations.errorOnServer[language];
            msgSuccessErrorHtml.warning(title, messsage, msgSuccessErrorHtmlSelector);
            //------------ Operation Message End--------------------
            return false;      
        });
    }
   </script>


   

    <!-- script end -->

    


</body>



</html>